% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcamodelo.R
\name{mcamodelobis}
\alias{mcamodelobis}
\title{Basic MCA function for clasification}
\usage{
mcamodelobis(dataf=dataf,listconti,listclass, vardep,bins=8,selec=0,
Dime1="Dim.1",Dime2="Dim.2")
}
\arguments{
\item{dataf}{data frame.}

\item{listconti}{Interval variables to use, in format c("var1","var2",...).}

\item{listclass}{Class variables to use, in format c("var1","var2",...).}

\item{vardep}{Dependent binary classification variable.}

\item{bins}{Number of bins for categorize interval variables .}

\item{selec}{1 if stepwise logistic variable selection is required, 0 if not.}

\item{Dime1, Dime2}{MCA Dimensions to consider. Dim.1 and Dim.2 by default.}
}
\value{
A list with the following objects:\describe{
\item{df1}{ dataset used for graph1}
\item{df2}{ dataset used for graph2}
\item{df3}{ dataset used for graph2}
\item{listconti}{ interval variables used}
\item{listclass}{ class variables used}
\item{axisx}{ axis definition in plot}
\item{axisy}{axis definition in plot}
}
}
\description{
This function presents visual graphics by means of Multiple correspondence Analysis projection.
Interval variables are categorized to bins.
Dependent classification variable is set as supplementary variable. It is used as base for mcacontour function.
}
\examples{
data(breastwisconsin1)
dataf<-breastwisconsin1
listconti=c( "clump_thickness","uniformity_of_cell_shape","mitosis")
listclass=c("")
vardep="classes"
result<-mcacontour(dataf=dataf,listconti,listclass,vardep,bins=8,title="",selec=1)
}
\keyword{MCA}
