% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freq.R
\name{vmtable}
\alias{vmtable}
\title{Rounds a contingency table of meteor magnitude frequencies}
\usage{
vmtable(mt)
}
\arguments{
\item{mt}{table; A two-dimensional contingency table of meteor magnitude frequencies.}
}
\value{
A rounded contingency table of meteor magnitudes is returned.
}
\description{
The meteor magnitude contingency table of VMDB contains half meteor counts (e.g. \code{3.5}).
This function converts these frequencies to integer values.
}
\details{
The contingency table of meteor magnitudes \code{mt} must be two-dimensional.
The row names refer to the magnitude observations.
Column names must be integer meteor magnitude values.
Also, the columns must be sorted in ascending or descending order of meteor magnitude.

A sum-preserving algorithm is used for rounding.
It ensures that the total frequency of meteors per observation is preserved.
The marginal frequencies of the magnitudes are also preserved with
the restriction that the deviation is at most \eqn{\pm 0.5}.
If the total sum of a meteor magnitude is integer,
then the deviation is \eqn{\pm 0}.

The algorithm is unbiased: for a fixed observation order it preserves the original
totals without introducing systematic drift, even though each run follows the
deterministic sequence dictated by the observed counts and their ordering.
}
\note{
Internally the counts are doubled to half-meteor units, leftover halves are
alternated between rows so column margins stay within \eqn{\pm 0.5}, and when the
grand total is odd the matrix is temporarily mirrored so the unavoidable surplus
meteor originates from the opposite end of the magnitude scale rather than always
favouring the faintest bin. The mirroring is only the initial condition; the loop
then processes the table cell by cell so the rounding direction alternates between
bright and faint magnitudes depending on the current row and column state.
}
\examples{
# For example, create a contingency table of meteor magnitudes
mt <- as.table(matrix(
    c(
        0.0, 0.0, 2.5, 0.5, 0.0, 1.0,
        0.0, 1.5, 2.0, 0.5, 0.0, 0.0,
        1.0, 0.0, 0.0, 3.0, 2.5, 0.5
    ), nrow = 3, ncol = 6, byrow = TRUE
))
colnames(mt) <- seq(6)
rownames(mt) <- c('A', 'B', 'C')
mt
margin.table(mt, 1)
margin.table(mt, 2)

# contingency table with integer values
(mt.int <- vmtable(mt))
margin.table(mt.int, 1)
margin.table(mt.int, 2)
}
