% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_releves.R
\name{add_releves}
\alias{add_releves}
\alias{add_releves,vegtable,data.frame-method}
\alias{add_releves<-}
\alias{add_releves<-,vegtable,data.frame-method}
\title{Merge relevés from data frames into vegtable objects}
\usage{
add_releves(vegtable, releves, ...)

\S4method{add_releves}{vegtable,data.frame}(
  vegtable,
  releves,
  header,
  abundance,
  split_string,
  usage_ids = FALSE,
  layers = FALSE,
  layers_var,
  format = "crosstable",
  preserve_ids = FALSE,
  ...
)

add_releves(vegtable, ...) <- value

\S4method{add_releves}{vegtable,data.frame}(vegtable, ...) <- value
}
\arguments{
\item{vegtable}{An object of class \linkS4class{vegtable}.}

\item{releves}{A data frame including plot observations to be added into
\code{vegtable}.}

\item{...}{Further arguments passed to function \code{\link[=cross2db]{cross2db()}} (i.e.
\code{na_strings}).}

\item{header}{A data frame (optional) including header information for plots.}

\item{abundance}{A character value (or vector of length 2) indicating the
names of abundance variable in \code{vegtable}.}

\item{split_string}{Character value used to split mixed abundance codes.}

\item{usage_ids}{Logical value indicating whether species are as taxon usage
ids (integers) or names in \code{releves}.}

\item{layers}{Logical value indicating whether layers are included in
\code{releves} or not.}

\item{layers_var}{Name of the layer variable in \code{vegtable}.}

\item{format}{Character value indicating input format of \code{releves} (either
\code{"crosstable"} or \code{"databaselist"}).}

\item{preserve_ids}{A logical value, whether IDs in input data set should
used as \code{ReleveID} or not. Those IDs have to be integers and if one
of those already exists in \code{vegtable}, an error will be retrieved.}

\item{value}{A data frame containing new plot observations. I is passed to
parameter 'releves' by the replace method.}
}
\description{
Addition of plot observations into existing data sets may implicate merging
data frames with \linkS4class{vegtable} objects.

Since this function will only update slots \strong{samples} and \strong{header},
consistency with slots \strong{layers}, \strong{relations} and \strong{species} have to be
checked and accordingly updated in advance.
}
\seealso{
\code{\link[=cross2db]{cross2db()}}
}
\author{
Miguel Alvarez \email{kamapu78@gmail.com}
}
