% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{twbx_extract_files}
\alias{twbx_extract_files}
\title{Extract specific files from a .twbx}
\usage{
twbx_extract_files(
  twbx_path,
  files = NULL,
  pattern = NULL,
  types = NULL,
  exdir = NULL
)
}
\arguments{
\item{twbx_path}{Path to a \code{.twbx}.}

\item{files}{Vector of archive paths to extract (optional).}

\item{pattern}{Perl regex to match archive paths (optional).}

\item{types}{Subset by \code{.twbx} entry \code{type} (see \code{\link[=twbx_list]{twbx_list()}}) (optional).}

\item{exdir}{Output directory (defaults to temp).}
}
\value{
Tibble with \code{name}, \code{type}, and \code{out_path} of extracted files.
}
\description{
Extract specific files from a .twbx
}
\examples{
\dontshow{if (nzchar(system.file("extdata", "test_for_zip.twbx", package = "twbparser"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
twbx <- system.file("extdata", "test_for_zip.twbx", package = "twbparser")
files <- twbx_extract_files(twbx, types = c("workbook"))
head(files)
\dontshow{\}) # examplesIf}
}
