% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_aug_jitter.R
\name{ts_aug_jitter}
\alias{ts_aug_jitter}
\title{Augmentation by Jitter}
\usage{
ts_aug_jitter()
}
\value{
A \code{ts_aug_jitter} object.
}
\description{
Time series augmentation by adding low-amplitude random noise to
each point to increase robustness and reduce overfitting.
}
\details{
Noise scale is estimated from within-window deviations.
}
\examples{
# Jitter augmentation with noise estimated from windows
# Load package and example dataset
library(daltoolbox)
data(tsd)

# Convert to sliding windows and preview
xw <- ts_data(tsd$y, 10)
ts_head(xw)

# Apply jitter (adds small noise; keeps target column unchanged)
augment <- ts_aug_jitter()
augment <- fit(augment, xw)
xa <- transform(augment, xw)
ts_head(xa)
}
\references{
\itemize{
\item J. T. Um et al. (2017). Data augmentation of wearable sensor data for
Parkinson’s disease monitoring using convolutional neural networks.
\item Q. Wen et al. (2021). Time Series Data Augmentation for Deep Learning:
A Survey. IJCAI Workshop on Time Series.
}
}
