% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funcSTLS.R
\name{funcSTLS}
\alias{funcSTLS}
\title{Function to be used by boot to obtain bootstrap replicates of the parameters estimated with STLS}
\usage{
funcSTLS(mf, mf_orig, d, formula, beta, bet, point, direction, control)
}
\arguments{
\item{mf}{the \code{model.frame} containing the variables to be used when fitting the model.}

\item{mf_orig}{original model frame (before possible manipulations due to non-default truncation point or direction) used to ensure correct order of attributes in the call to \code{\link[truncreg]{truncreg}}}

\item{d}{vector of indices to define the bootstrap samples}

\item{formula}{a symbolic description of the model to be estimated}

\item{beta}{the method of determining the starting values of the regression coefficients}

\item{bet}{starting values to be used by \code{\link{optim}}. Only used if beta is numeric.}

\item{point}{the point of truncation}

\item{direction}{the direction of truncation}

\item{control}{list of control parameters to be used by \code{\link{optim}}}
}
\description{
Function to be used by boot to obtain bootstrap replicates of the parameters estimated with STLS
}
\author{
Anita Lindmark and Maria Karlsson
}
