% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/q_matrix.R
\name{augment_q_matrix}
\alias{augment_q_matrix}
\alias{augment.q_matrix}
\title{Augment data with information from a q_matrix object}
\usage{
\method{augment}{q_matrix}(x, data = NULL, ...)
}
\arguments{
\item{x}{A \code{q_matrix} object}

\item{data}{the \code{gen_tibble} used to run the clustering algorithm}

\item{...}{Not used. Needed to match generic signature only.}
}
\value{
A  \link{gen_tibble} containing the original data along with additional
columns containing each observation's Q values.
}
\description{
Augment for \code{q_matrix} accepts a model object and a dataset and adds Q values
to each observation in the dataset. Q values  are stored in separate columns,
which is given name with the pattern ".Q1",".Q2", etc. For consistency with
\link[broom:augment.prcomp]{broom::augment.prcomp}, a column ".rownames" is also returned; it is a copy
of 'id', but it ensures that any scripts written for data augmented with
\link[broom:augment.prcomp]{broom::augment.prcomp} will work out of the box (this is especially helpful
when adapting plotting scripts).
}
\examples{
# run the example only if we have the package installed
if (requireNamespace("LEA", quietly = TRUE)) {
  example_gt <- load_example_gt("gen_tbl")

  # Create a gt_admix object
  admix_obj <- example_gt \%>\% gt_snmf(k = 1:3, project = "force")

  # Extract a Q matrix
  q_mat_k3 <- get_q_matrix(admix_obj, k = 3, run = 1)

  # Augment the gen_tibble with Q values
  augment(q_mat_k3, data = example_gt)
}
}
