% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{tau2time}
\alias{tau2time}
\alias{time2tau}
\title{Convert changepoint sets to time indices}
\usage{
tau2time(tau, index)

time2tau(cpts, index)
}
\arguments{
\item{tau}{a numeric vector of changepoint indices}

\item{index}{Index of times, typically returned by \code{\link[stats:time]{stats::time()}}}

\item{cpts}{Time series observation labels to be converted to indices}
}
\value{
\itemize{
\item \code{\link[=tau2time]{tau2time()}}: a \code{character} of time labels
}

\itemize{
\item \code{\link[=time2tau]{time2tau()}}: an \code{integer} vector of changepoint indices
}
}
\description{
Convert changepoint sets to time indices
}
\examples{
# Recover the years from a set of changepoint indices
tau2time(c(42, 81, 330), index = as_year(time(CET)))

# Recover the changepoint set indices from the years
time2tau(c(1700, 1739, 1988), index = as_year(time(CET)))

}
\seealso{
\code{\link[stats:time]{stats::time()}}, \code{\link[=as_year]{as_year()}}
}
