% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parser.R
\name{parse}
\alias{parse}
\title{Parse a single thrift file to R6 class instance}
\usage{
parse(path, module_name = NA, include_dirs = NA, lexer = NA,
  parser = NA, enable_cache = TRUE)
}
\arguments{
\item{path}{file path to parse, should be a string ending with '.thrift'}

\item{module_name}{the name for parsed module, the default is the basename
without extension of `path`}

\item{include_dirs}{directories to find thrift files while processing
the `include` directive, by default: ['.']}

\item{lexer}{rly lexer to use, if not provided, `parse` will use a new one}

\item{parser}{rly parser to use, if not provided, `parse` will use a new one}

\item{enable_cache}{if this is set to be `TRUE`, parsed module will be
cached, this is enabled by default. If `module_name`
is provided, use it as cache key, else use the `path`}
}
\value{
Thrift module
}
\description{
Parse a single thrift file to R6 class instance
}
