% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_panel_api.R
\name{filter_state_api}
\alias{filter_state_api}
\alias{set_filter_state}
\alias{get_filter_state}
\alias{remove_filter_state}
\alias{clear_filter_states}
\title{Managing \code{FilteredData} states}
\usage{
set_filter_state(datasets, filter)

get_filter_state(datasets)

remove_filter_state(datasets, filter)

clear_filter_states(datasets, force = FALSE)
}
\arguments{
\item{datasets}{(\code{FilteredData})
object to store filter state and filtered datasets, shared across modules

see \code{\link{FilteredData}} for details}

\item{filter}{(\code{teal_slices})
specify filters in place on app start-up}

\item{force}{(\code{logical(1)})
flag specifying whether to include anchored filter states.}
}
\value{
\itemize{
\item \verb{set_*}, \verb{remove_*} and \code{clear_filter_state} return \code{NULL} invisibly
\item \code{get_filter_state} returns a named \code{teal_slices} object
containing a \code{teal_slice} for every existing \code{FilterState}
}
}
\description{
Set, get and remove filter states of \code{FilteredData} object.
}
\examples{
datasets <- init_filtered_data(list(iris = iris, mtcars = mtcars))
fs <- teal_slices(
  teal_slice(dataname = "iris", varname = "Species", selected = c("setosa", "versicolor")),
  teal_slice(dataname = "iris", varname = "Sepal.Length", selected = c(5.1, 6.4)),
  teal_slice(dataname = "mtcars", varname = "gear", selected = c(4, 5)),
  teal_slice(dataname = "mtcars", varname = "carb", selected = c(4, 10))
)

# set initial filter state
set_filter_state(datasets, filter = fs)

# get filter state
get_filter_state(datasets)

# modify filter state
set_filter_state(
  datasets,
  teal_slices(
    teal_slice(dataname = "iris", varname = "Species", selected = "setosa", keep_na = TRUE)
  )
)

# remove specific filters
remove_filter_state(
  datasets,
  teal_slices(
    teal_slice(dataname = "iris", varname = "Species"),
    teal_slice(dataname = "mtcars", varname = "gear"),
    teal_slice(dataname = "mtcars", varname = "carb")
  )
)

# remove all states
clear_filter_states(datasets)

\donttest{
if (requireNamespace("MultiAssayExperiment", quietly = TRUE)) {
  # Requires MultiAssayExperiment from Bioconductor
  data(miniACC, package = "MultiAssayExperiment")

  datasets <- init_filtered_data(list(mae = miniACC))
  fs <- teal_slices(
    teal_slice(
      dataname = "mae", varname = "years_to_birth", selected = c(30, 50),
      keep_na = TRUE, keep_inf = FALSE
    ),
    teal_slice(
      dataname = "mae", varname = "vital_status", selected = "1",
      keep_na = FALSE
    ),
    teal_slice(
      dataname = "mae", varname = "gender", selected = "female",
      keep_na = TRUE
    ),
    teal_slice(
      dataname = "mae", varname = "ARRAY_TYPE", selected = "",
      keep_na = TRUE, experiment = "RPPAArray", arg = "subset"
    )
  )

  # set initial filter state
  set_filter_state(datasets, filter = fs)

  # get filter state
  get_filter_state(datasets)

  # modify filter state
  set_filter_state(
    datasets,
    teal_slices(
      teal_slice(dataname = "mae", varname = "years_to_birth", selected = c(40, 60))
    )
  )

  # remove specific filters
  remove_filter_state(
    datasets,
    teal_slices(
      teal_slice(dataname = "mae", varname = "years_to_birth"),
      teal_slice(dataname = "mae", varname = "vital_status")
    )
  )

  # remove all states
  clear_filter_states(datasets)
}
}
}
\seealso{
\code{\link{teal_slice}}
}
