% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freq.R
\name{pitch_freq}
\alias{pitch_freq}
\alias{pitch_semitones}
\alias{chord_freq}
\alias{chord_semitones}
\alias{freq_pitch}
\alias{freq_semitones}
\alias{semitone_pitch}
\alias{semitone_freq}
\title{Pitch conversions}
\usage{
pitch_freq(notes, a4 = 440)

pitch_semitones(notes)

chord_freq(notes, a4 = 440)

chord_semitones(notes)

freq_pitch(
  freq,
  octaves = c("tick", "integer"),
  accidentals = c("flat", "sharp"),
  collapse = FALSE,
  a4 = 440
)

freq_semitones(freq, a4 = 440)

semitone_pitch(
  semitones,
  octaves = c("tick", "integer"),
  accidentals = c("flat", "sharp"),
  collapse = FALSE
)

semitone_freq(semitones, a4 = 440)
}
\arguments{
\item{notes}{character, noteworthy string, space-delimited or vector of
individual entries. See details.}

\item{a4}{the fixed frequency of the A above middle C, typically 440 Hz.}

\item{freq}{numeric vector, frequencies in Hz.}

\item{octaves}{\code{NULL} or character, \code{"tick"} or \code{"integer"} octave numbering
in result.}

\item{accidentals}{\code{NULL} or character, represent accidentals, \code{"flat"} or
\code{"sharp"}.}

\item{collapse}{logical, collapse result into a single string. \code{key} and
\code{style}.}

\item{semitones}{integer values of pitches.}
}
\value{
integer, numeric or noteworthy vector
}
\description{
Convert between pitches, chords, semitones and frequencies.
}
\details{
Frequencies are in Hertz. Values are based on the 12-tone equal-tempered
scale. When converting an arbitrary frequency to pitch, it is rounded to the
nearest pitch.
\code{pitch_freq()} and \code{pitch_semitones()} strictly accept single notes in
noteworthy strings and return numeric vectors.
\code{chord_freq()} and \code{chord_semitones()} accept any noteworthy string and
always return a list. These are provided so that all functions are type-safe.
See examples.
}
\examples{
x <- "a e4 a4 e5 a5"
y <- pitch_freq(x)
y

freq_semitones(y)
freq_pitch(y)

identical(as_noteworthy(x), freq_pitch(y, "integer", collapse = TRUE))

s <- pitch_semitones(x)
s
semitone_pitch(s)

x <- "a, a,c#e"
chord_semitones(x)
chord_freq(x)
}
