% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/superb-package.R
\docType{package}
\name{superb-package}
\alias{superb-package}
\title{superb: Summary Plots with Adjusted Error Bars}
\description{
Computes standard error and confidence interval of various descriptive statistics under various designs and sampling schemes. The main function, superb(), return a plot. It can also be used to obtain a dataframe with the statistics and their precision intervals so that other plotting environments (e.g., Excel) can be used. See Cousineau and colleagues (2021) \doi{10.1177/25152459211035109} or Cousineau (2017) \doi{10.5709/acp-0214-z} for a review as well as Cousineau (2005) \doi{10.20982/tqmp.01.1.p042}, Morey (2008) \doi{10.20982/tqmp.04.2.p061}, Baguley (2012) \doi{10.3758/s13428-011-0123-7}, Cousineau & Laurencelle (2016) \doi{10.1037/met0000055}, Cousineau & O'Brien (2014) \doi{10.3758/s13428-013-0441-z}, Calderini & Harding \doi{10.20982/tqmp.15.1.p001} for specific references. The documentation is available at \url{https://dcousin3.github.io/superb/} .
}
\details{
`suberb` is a library to perform descriptive statistics plots
based on the superb framework. In a nutshell, the framework 
assert that confidence intervals must be devised according to 
all the relevant information that can be used to assess precision.
For example, confidence intervals should be informed of the presence
of within-subject design, of the fact that the sample is random or clustered,
of whether the population is finite or infinite, etc.

Would you do a t-test on independent groups when you know that the data
are paired? Of course, not! Why use the classic "stand-alone" confidence interval then?
These classic confidence intervals are oblivious to most relevant information.

The superb framework is based on the idea that correct, well-informed, confidence 
intervals can be obtained with a succession of simple corrections. I call these
"adjusted confidence intervals". 

The main function is

   \code{superb(formula, dataframe,  ...)}  

where \code{df} is a dataframe.

For more details on the underlying math, see
\insertCite{c05,c19,c17,cl16,m08,b12,lm94,gc19}{superb}

A second function inserted in this package is \insertCite{ch19}{superb}

   \code{GRD( ...)}

which generates random datasets. It easily generate ficticious dataset
so that superbPlot can be tested rapidly. This function is described in 
\insertCite{ch19}{superb}.
}
\references{
\insertAllCited{}

The package includes additional, helper, functions: \itemize{
     \item{\code{ShroutFleissICC1}} to compute intra-class correlation;
     \item{\code{epsilon}} to compute the sphericity measure;
     \item{\code{lambda}} to compute the cluster-sampling adjustment;
     \item{\code{MauchlySphericityTest}} to perform a test of sphericity;
     \item{\code{WinerCompoundSymmetry}} to perform a test of compound symmetry;
}
and example datasets described in the paper:  \itemize{
     \item\code{dataFigure1} illustrate the paradox of using stand-alone CI in between-group design;
     \item{\code{dataFigure2}} illustrate the paradox of using stand-alone CI in within-subject design;
     \item{\code{dataFigure3}} illustrate the paradox of using stand-alone CI in cluster-randomized sampling study;
     \item{\code{dataFigure4}} illustrate the paradox of using stand-alone CI with population of finite size.
}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/dcousin3/superb/}
  \item \url{https://CRAN.R-project.org/package=superb}
  \item \url{https://dcousin3.github.io/superb/}
  \item Report bugs at \url{https://github.com/dcousin3/superb/issues/}
}

}
\author{
\strong{Maintainer}: Denis Cousineau \email{denis.cousineau@uottawa.ca}

Other contributors:
\itemize{
  \item Bradley Harding \email{bradley.harding@umoncton.ca} [contributor]
  \item Marc-Andre Goulet \email{magoulet101@gmail.com} [contributor]
  \item Jesika Walker \email{jwalk050@uottawa.ca} [artist, presenter]
}

}
\keyword{internal}
