% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spareg.R
\name{get_coef}
\alias{get_coef}
\title{Extractor for Model Coefficients from \code{'coefspar'} Object}
\usage{
get_coef(x)
}
\arguments{
\item{x}{A `\code{coefspar}' object.}
}
\value{
A numeric vector or matrix of coefficients.
}
\description{
Extractor for Model Coefficients from \code{'coefspar'} Object
}
\examples{
example_data <- simulate_spareg_data(n = 100, p = 400, ntest = 100)
spar_res <- spar(example_data$x, example_data$y, xval = example_data$xtest,
  yval = example_data$ytest, nummods=c(5, 10))
coefs <- coef(spar_res)
get_coef(coefs)
}
\seealso{
\link{coef.spar}, \link{coef.spar.cv}, \link{print.coefspar}, \link{summary.coefspar}
}
