% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparmodel_classes.R
\name{constructor_sparmodel}
\alias{constructor_sparmodel}
\title{Constructor Function for Building \code{'sparmodel'} Object}
\usage{
constructor_sparmodel(name, model_fun, update_fun = NULL)
}
\arguments{
\item{name}{character}

\item{model_fun}{function for estimating the marginal models which returns the
function should have arguments  and   \code{y} (vector of responses -- standardized
for Gaussian family), \code{z} (the matrix of projected predictors) and a
\code{'sparmodel'} \code{object}.}

\item{update_fun}{optional function for updating the \code{'sparmodel'} object
before the
start of the algorithm.}
}
\value{
a function which in turn creates an
object of class \code{'sparmodel'}.
}
\description{
The created function will return a object of class \code{'sparmodel'} which
constitutes of a list.
}
\details{
Creates an object of class \code{'sparmodel'} using arguments passed by user.
}
\examples{
model_glmrob <- function(y, z, object) {
  requireNamespace("robustbase")
  fam <- object$control$family
  glmrob_res <- do.call(function(...)
    robustbase::glmrob(y ~ as.matrix(z), ...),
    object$control)
  intercept <- coef(glmrob_res)[1]
  gammas <- coef(glmrob_res)[-1]
  list(gammas = gammas, intercept = intercept)
}
spar_glmrob <- constructor_sparmodel(name = "glmrob",
  model_fun = model_glmrob)
example_data <- simulate_spareg_data(n = 100, p = 400, ntest = 100)
spar_res <- spar(example_data$x, example_data$y, xval = example_data$xtest,
  yval = example_data$ytest,
  model = spar_glmrob())
spar_res
}
