% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simaerep.R
\name{eval_sites}
\alias{eval_sites}
\title{Evaluate sites.}
\usage{
eval_sites(
  df_sim_sites,
  method = "BH",
  under_only = TRUE,
  visit_med75 = TRUE,
  ...
)
}
\arguments{
\item{df_sim_sites}{dataframe generated by \code{\link[simaerep]{sim_sites}} or \code{\link[=sim_inframe]{sim_inframe()}}}

\item{method}{character, passed to stats::p.adjust(), if NULL no multiplicity correction
will be made.}

\item{under_only}{Logical, compute under-reporting probabilities only.
only applies to the classic algorithm in which a one-sided evaluation can
save computation time. Default: FALSE}

\item{visit_med75}{Logical, should evaluation point visit_med75 be used. Compatible
with inframe and classic version of the algorithm.
Default: FALSE}

\item{...}{use to pass r_sim_sites parameter to eval_sites_deprecated()}
}
\value{
dataframe with the following columns:
\describe{
\item{\strong{study_id}}{study identification}
\item{\strong{site_number}}{site identification}
\item{\strong{visit_med75}}{median(max(visit)) * 0.75}
\item{\strong{mean_ae_site_med75}}{mean AE at visit_med75 site level}
\item{\strong{mean_ae_study_med75}}{mean AE at visit_med75 study level}
\item{\strong{pval}}{p-value as returned by \code{\link[stats]{poisson.test}}}
\item{\strong{prob}}{bootstrapped probability}

}
}
\description{
Correct under-reporting probabilities using  \code{\link[stats]{p.adjust}}.
}
\examples{
df_visit <- sim_test_data_study(
  n_pat = 100,
  n_sites = 5,
  ratio_out = 0.4,
  factor_event_rate = 0.6
  ) \%>\%
  # internal functions require internal column names
  dplyr::rename(
    n_ae = n_event,
    site_number = site_id,
    patnum = patient_id
  )

df_site <- site_aggr(df_visit)

df_sim_sites <- sim_sites(df_site, df_visit, r = 100)

df_eval <- eval_sites(df_sim_sites)
df_eval

}
\seealso{
\code{\link[simaerep]{site_aggr}},
\code{\link[simaerep]{sim_sites}},
\code{\link[simaerep]{sim_inframe}},
\code{\link[stats]{p.adjust}}
}
\keyword{internal}
