% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample-size.R
\name{silv_sample_size_stratified}
\alias{silv_sample_size_stratified}
\title{Calculates sample size for a stratified sampling}
\usage{
silv_sample_size_stratified(
  data,
  x,
  strata,
  total_area,
  plot_size,
  method = "optimal",
  cost = NA,
  max_error = 0.05,
  conf_level = 0.95,
  max_iter = 1000,
  currency = "EUR",
  quiet = FALSE
)
}
\arguments{
\item{data}{a \code{data.frame} of pilot inventory data}

\item{x}{name of the variable in \code{data} that was measured (e.g. basal area, volume)}

\item{strata}{name of the variable in \code{data} with the name of the stratum}

\item{total_area}{name of the variable in \code{data} with the area of the stratum}

\item{plot_size}{a numeric vector of length one with plot size in squared meters}

\item{method}{a charater vector of length one with the id of the method. Available
options are \code{optimal}, \code{cost}, and \code{prop}. See details}

\item{cost}{name of the variable in \code{data} with the average cost of measuring one plot
of the stratum. Used with \code{method = 'cost'} for sample size, and for message output in
other methods}

\item{max_error}{maximum allowed relative error}

\item{conf_level}{confidence level}

\item{max_iter}{maximum number of iteration to find the plot size}

\item{currency}{currency to be shown in console output when using \code{method = 'cost'}}

\item{quiet}{if \code{TRUE}, messages will be supressed}
}
\value{
S7 \code{StratifiedSampleSize} object with:
\itemize{
\item \strong{results}: \code{data.frame} with the main results by stratum
\item \strong{strata_error}: \code{data.frame} with maximum absolute error \eqn{\mp} C.I (max_abs_error,
x_min, x_max), and the esimator of the typical error \eqn{\mp} C.I (sampling error, x_ci_lo,
x_ci_hi)
\item \strong{sampling_error}: \code{data.frame} with the maximum absolute error \eqn{\mp} C.I (max_abs_error,
x_min, x_max), and the typical sampling error of the weighted mean \eqn{\mp} C.I (sampling error,
x_ci_lo, x_ci_hi)
\item \strong{sampling_opts}: \code{list} with function options
}
}
\description{
Calculates the sample size needed for a stratified inventory, estimated from
pilot inventory data.
}
\details{
Stratified Sampling calculates the number of plots to be inventored in different strata.
For instance, you might have \emph{Pinus sylvestris} and \emph{Pinus pinaster} plots in the same
forest, and you might want to get the optimal number of plots for field inventory of each
stratum, for a given maximum relative error (e.g. 5\%), and with a certain level of confidence
(e.g 95\%). Of course, the area of \emph{P. sylvestris} will be different than the area occupied by
\emph{P. pinaster}. For instance, the total area of \emph{P. sylvestris} could be 100 ha, while the area
of \emph{P. pinaster} could be 200 ha. Therefore, you need to create a pilot inventory and measure
a variable such as basal area maybe in 5 pilot plots of \emph{P. sylvestris} and 7 pilot plots of
\emph{P. pinaster}. With that data collected, you can use three stratified sample size methods:
\itemize{
\item \strong{Optimal Allocation with Constant Cost}: using \code{method = 'optimal'}. The sampling units
are distributed within the different strata taking into account the size (e.g. 100 ha vs 200
ha) and the heterogeinity (e.g. differences in basal area). It minimizes the number of
sampling units.
}

\eqn{n = \frac{t^2_{n - m} \cdot (\sum^{j = m}_{j = 1} P_j \cdot s_j)^2 }{\epsilon^2 + \frac{t^2_{n - m} \cdot \sum^{j = m}_{j = 1} P_j \cdot s_j^2}{N}}}
\itemize{
\item \strong{Optimal Allocation with Variable Cost}: using \code{method = 'cost'}. This method needs to know
the cost of a sampling unit in each strata. It will minimize the cost of the inventory,
taking into account the size, the heterogeinity, and the cost of the sampling unit of the strata.
}

\eqn{n = \frac{t^2_{n-m} \cdot (\sum^{j = m}_{j = 1} \cdot P_j \cdot s_j \cdot \sqrt{c_j}) \cdot (\sum^{j = m}_{j = 1} \cdot \frac{P_j \cdot s_j}{\sqrt{c_j}})}{\epsilon^2 + \frac{t^2_{n - m} \cdot \sum^{j = m}_{j = 1} P_j \cdot s_j^2}{N}}}
\itemize{
\item \strong{Proportional Allocation}: using \code{method = 'prop'}. The sampling units are distributed
proportional to the size of the strata. In the example, 33\% of the estimated sampling
units will be allocated to \emph{P. sylvestris} and 66\% to \emph{P. pinaster}.
}

\eqn{n = \frac{t^2_{n - m} \cdot \sum^{j = m}_{j = 1} P_j \cdot s_j^2 }{\epsilon^2 + \frac{t^2_{n - m} \cdot \sum^{j = m}_{j = 1} P_j \cdot s_j^2}{N}}}

Where:
\itemize{
\item \strong{n}: estimated sample size
\item \strong{t}: the value of student's t
\item \strong{\eqn{P_j}}: proportion of pilot plots of \eqn{j^{th}} strata
\item \strong{\eqn{s_j}}: standard deviation of \code{x}
\item \strong{\eqn{s_j^2}}: variance of \code{x}
\item \strong{N}: population size (number of plots of \code{plot_size} that fit in \code{total_area})
\item \strong{\eqn{\epsilon}}: maximum allowed absolute error. Calculated from \code{x} and \code{max_error}
\item \strong{N}: the size of the pilot inventory
}
}
\examples{
## read pilot inventory ficticious data
data_path <- system.file("extdata/pilot_inventory.csv", package = "silviculture")
inventory_tbl <- read.csv(data_path)

## calculate sample size
sample_size_list <- silv_sample_size_stratified(
  data  = inventory_tbl,
  x     = basal_area,
  strata = stratum,
  total_area = area,
  method = "optimal",
  cost = cost,
  plot_size = 100,
  conf_level = .95,
  max_error = .05
)
}
