% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MkAgePrior.R
\name{GetLLRAge}
\alias{GetLLRAge}
\title{LLR-age from Ageprior Matrix}
\usage{
GetLLRAge(AgePriorExtra, agedif, patmat)
}
\arguments{
\item{AgePriorExtra}{matrix in \code{\link{sequoia}} output}

\item{agedif}{vector with age differences, in whole numbers. Must occur in
rownames of \code{AgePriorExtra}.}

\item{patmat}{numeric vector; choose maternal (1), paternal (2) relatives, or
for each relationship the most-likely alternative (3).}
}
\value{
A matrix with \code{nrow} equal to the length of \code{agedif}, and 7
  columns: PO-FS-HS-GP-FA-HA-U.
}
\description{
Get log10-likelihood ratios for a specific age difference from
  matrix \code{AgePriorExtra}.
}
\details{
This is a simple helper function to extract values from
 \code{AgePriorExtra}, e.g. to use together with \code{\link{CalcPairLL}}.
}
\examples{
# For a pair with unknown age difference, explore the difference age-based
# LLRs for all relationships, for a range of plausible age differences.
PairsG <- data.frame(ID1 = 'A', ID2 = 'B', AgeDif = rep(c(-2,2,3),2),
                   PatMat = rep(1:2, each=3))
cbind(PairsG,
      GetLLRAge(SeqOUT_griffin$AgePriorExtra,
                agedif = PairsG$AgeDif, patmat = PairsG$PatMat))

}
