\name{imageScale}
\alias{imageScale}
\title{Make a color scale to accompany an image or other plot}
\usage{
imageScale(z, zlim, col = heat.colors(12), breaks, axis.pos = 1,
  add.axis = TRUE, xlim = NULL, ylim = NULL, log, ...)
}
\arguments{
\item{z}{A vector or matrix of values.}

\item{zlim}{Limits of the color scale values.}

\item{col}{Vector of color values (default is 12 colors 
from the \code{\link[grDevices]{heat.colors}} palette).}

\item{breaks}{Break points for color changes. If breaks is specified then \code{zlim} 
is unused and the algorithm used follows \code{\link[base]{cut}}, so intervals are 
closed on the right and open on the left except for the lowest interval 
which is closed at both ends.}

\item{axis.pos}{Position of the axis (1=bottom, 2=left, 3=top, 4=right) (default = 1).}

\item{add.axis}{Logical (TRUE/FALSE). Defines whether the axis is added (default: TRUE).}

\item{xlim}{Limits for the x-axis.}

\item{ylim}{Limits for the y-axis.}

\item{log}{logical. If \code{TRUE}, z is log transformed (base 10).}

\item{...}{Additional graphical parameters to pass to the \code{\link[graphics]{image}} function.}
}
\description{
The \code{imageScale} function is wrapper for \code{imageScale} and accepts the same arguments.  It converts a vector of values (\code{z}) to a vector of color levels.  One must define the number of colors.  The limits of the color scale ("zlim") or the break points for the color changes("breaks") can also be defined.  When breaks and zlim are defined, breaks overrides zlim. All arguments are similar to those in the \code{image} function.  Appearance is best when incorporated with \code{\link[graphics]{layout}}.
}
\author{
Marc Taylor, modified for log scale by Héctor Villalobos
}
\examples{
# Make color palettes
pal.1=colorRampPalette(c("green4", "orange", "red", "white"), space="rgb", bias=0.5)
pal.2=colorRampPalette(c("blue", "cyan", "yellow", "red", "pink"), space="rgb")

# Make images with corresponding scales
op <- par(no.readonly = TRUE)
layout(matrix(c(1,2,3,0,4,0), nrow=2, ncol=3), widths=c(4,4,1), heights=c(4,1))
#layout.show(4)
#1st image
breaks <- seq(min(volcano), max(volcano),length.out=100)
par(mar=c(1,1,1,1))
image(seq(dim(volcano)[1]), seq(dim(volcano)[2]), volcano, 
col=pal.1(length(breaks)-1), breaks=breaks-1e-8, xaxt="n", yaxt="n", ylab="", xlab="")
#Add additional graphics
levs <- pretty(range(volcano), 5)
contour(seq(dim(volcano)[1]), seq(dim(volcano)[2]), volcano, levels=levs, add=TRUE)
#Add scale
par(mar=c(3,1,0,1))
imageScale(volcano, col=pal.1(length(breaks)-1), breaks=breaks-1e-8,axis.pos=1)
abline(v=levs)
box()

#2nd image
breaks <- c(0,100, 150, 170, 190, 200)
par(mar=c(1,1,1,1))
image(seq(dim(volcano)[1]), seq(dim(volcano)[2]), volcano, 
col=pal.2(length(breaks)-1), breaks=breaks-1e-8, xaxt="n", yaxt="n", ylab="", xlab="")
#Add additional graphics
levs=breaks
contour(seq(dim(volcano)[1]), seq(dim(volcano)[2]), volcano, levels=levs, add=TRUE)
#Add scale
par(mar=c(1,0,1,3))
imageScale(volcano, col=pal.2(length(breaks)-1), breaks=breaks-1e-8, 
axis.pos=4, add.axis=FALSE)
axis(4,at=breaks, las=2)
box()
abline(h=levs)
par(op)
}

% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ hplot }
