% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saveDatasheet.R
\name{saveDatasheet}
\alias{saveDatasheet}
\alias{saveDatasheet,character-method}
\alias{saveDatasheet,SsimObject-method}
\title{Save datasheet}
\usage{
saveDatasheet(ssimObject, data, name = NULL, append = NULL, force = FALSE)

\S4method{saveDatasheet}{character}(ssimObject, data, name = NULL, append = NULL, force = FALSE)

\S4method{saveDatasheet}{SsimObject}(ssimObject, data, name = NULL, append = NULL, force = FALSE)
}
\arguments{
\item{ssimObject}{\code{\link{SsimLibrary-class}}, \code{\link{Project-class}}, or
\code{\link{Scenario-class}} object}

\item{data}{data.frame. The datasheet to load}

\item{name}{character. The name of the datasheet to be saved}

\item{append}{logical. If \code{TRUE}, the incoming data will be appended to the
datasheet if possible.  Default is \code{TRUE} for Project/SsimLibrary-scope datasheets,
and \code{FALSE} for Scenario-scope Datasheets. See 'details' for more information
about this argument}

\item{force}{logical. If datasheet scope is Project/SsimLibrary, and \code{append=FALSE},
datasheet will be deleted before loading the new data. This can also delete
other definitions and results, so if \code{force=FALSE} (default) user will be
prompted for approval}
}
\value{
Invisibly returns a vector or list of logical values for each
input: \code{TRUE} upon success (i.e.successful save) and \code{FALSE} upon failure.
}
\description{
Saves a datasheet to a \code{\link{SsimLibrary-class}}, \code{\link{Project-class}}, or
\code{\link{Scenario-class}}.
}
\details{
About the 'append' argument:

\itemize{
\item A Datasheet is a VALIDATION SOURCE if its data can be used to validate
column values in a different Datasheet.
\item The \code{append} argument will be ignored if the Datasheet is a validation
source and has a Project scope.  In this case the data will be MERGED.
}
}
\examples{
\dontrun{
# Specify file path and name of new SsimLibrary
myLibraryName <- file.path(tempdir(), "testlib")

# Set the SyncroSim Session, SsimLibrary, Project, and Scenario
mySession <- session()
myLibrary <- ssimLibrary(name = myLibraryName,
                         session = mySession,
                         packages = "helloworldSpatial")
myProject <- project(myLibrary, project = "Definitions")
myScenario <- scenario(myProject, scenario = "My Scenario")

# Get all Datasheet info
myDatasheets <- datasheet(myScenario)

# Get a specific Datasheet
myDatasheet <- datasheet(myScenario, name = "helloworldSpatial_RunControl")

# Modify Datasheet
myDatasheet$MaximumTimestep <- 10

# Save Datasheet
saveDatasheet(ssimObject = myScenario, 
              data = myDatasheet, 
              name = "helloworldSpatial_RunControl")
}

}
