% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robust_statis_phase1.R
\name{robust_statis_phase1}
\alias{robust_statis_phase1}
\title{Robust STATIS Dual - Phase 1 (Under Control Batches)}
\usage{
robust_statis_phase1(data, variables)
}
\arguments{
\item{data}{A data frame containing the process data with batch information.}

\item{variables}{Character vector with the names of the variables to be used in the analysis.}
}
\value{
A list containing:
\describe{
\item{compromise_matrix}{Robust compromise matrix (without trace normalization)}
\item{global_center}{Global robust center of the batches}
\item{batch_statistics}{Data frame with Batch, T2_Stat (Hotelling-type robust statistic), and Weight}
\item{batch_medians}{List of medians per batch and variable}
\item{batch_mads}{List of MADs per batch and variable }
\item{global_medians}{Global medians per variable (for use in Phase 2)}
\item{global_mads}{Global MADs per variable }
\item{robust_means}{List of robust centers of each batch (estimated by MCD)}
\item{standardized_data}{Data set standardized batch by batch}
\item{robust_covariances}{List of robust covariance matrices per batch}
\item{similarity_matrix}{Hilbert-Schmidt similarity matrix between batches}
\item{statis_weights}{Weights obtained from the first eigenvector of the similarity matrix}
\item{first_eigenvector}{First eigenvector of the similarity matrix (unnormalized)}
}
}
\description{
Applies the Robust STATIS Dual methodology to Phase 1 data (under control batches),
using robust batch-wise standardization (median and MAD ).
Covariance matrices are robustly estimated using the MCD method
and used directly (without trace normalization) to construct the compromise matrix.
}
\examples{
# Simulate new pharmaceutical manufacturing batches
sim_batches <- simulate_pharma_batches()

# Select only Phase 1 under control batches
phase1_data <- subset(sim_batches, Phase == "Phase 1" & Status == "Under Control")

# Apply robust STATIS Dual methodology
result <- robust_statis_phase1(
  data = phase1_data,
  variables = c("Concentration", "Humidity", "Dissolution", "Density")
)

# View main outputs
result$compromise_matrix
result$batch_statistics
result$robust_covariances
result$similarity_matrix
result$statis_weights
result$robust_means
}
