% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_spec.R
\name{print.text_spec}
\alias{print.text_spec}
\title{Prints the text spec}
\usage{
\method{print}{text_spec}(x, ..., verbose = FALSE)
}
\arguments{
\item{x}{The text spec.}

\item{...}{Additional parameters to pass to the underlying print function.}

\item{verbose}{Whether to print in verbose form.  Default is FALSE.}
}
\value{
The text spec, invisibly.
}
\description{
A function to print the text spec.
The \strong{print} function will print the text spec in summary 
form.  To view all parameters, set the \code{verbose} parameter to TRUE.
}
\examples{
txt <- create_text("Lorem ipsum dolor sit amet, consectetur...",
                   align = "left", width = 3)
txt

# A text specification: 6 words
# - text: Lorem ipsum dolor sit amet, consectetur...
# - width: 3
# - align: left
}
\seealso{
\code{\link{create_text}} function to create a text specification.

Other text: 
\code{\link{create_text}()}
}
\concept{text}
