% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter-butter.R
\name{butter_max_order}
\alias{butter_max_order}
\title{'Butterworth' filter with maximum order}
\usage{
butter_max_order(
  w,
  type = c("low", "high", "pass", "stop"),
  r = 10 * log10(2),
  tol = .Machine$double.eps
)
}
\arguments{
\item{w}{scaled frequency ranging from 0 to 1, where 1 is 'Nyquist' frequency}

\item{type}{filter type}

\item{r}{decibel attenuation at frequency \code{w}, default is around
\code{3 dB} (half power)}

\item{tol}{tolerance of reciprocal condition number, default is
\code{.Machine$double.eps}.}
}
\value{
'Butterworth' filter in 'Arma' form.
}
\description{
Large filter order might not be optimal, but at lease this function
provides a feasible upper bound for the order such that the
filter has a stable \code{AR} component.
}
\examples{

# Find highest order (sharpest transition) of a band-pass filter
sample_rate <- 500
nyquist <- sample_rate / 2

type <- "pass"
w <- c(1, 50) / nyquist
Rs <- 6     # power attenuation at w

# max order filter
filter <- butter_max_order(w, "pass", Rs)

# -6 dB cutoff should be around 1 ~ 50 Hz
diagnose_filter(filter$b, filter$a, fs = sample_rate)

}
