% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jobs.R
\name{rave-pipeline-jobs}
\alias{rave-pipeline-jobs}
\alias{start_job}
\alias{check_job}
\alias{resolve_job}
\alias{remove_job}
\title{Run a function (job) in another session}
\usage{
start_job(
  fun,
  fun_args = list(),
  packages = NULL,
  workdir = NULL,
  method = c("callr", "rs_job", "mirai"),
  name = NULL,
  ensure_init = TRUE,
  digest_key = NULL,
  envvars = NULL
)

check_job(job_id)

resolve_job(
  job_id,
  timeout = Inf,
  auto_remove = TRUE,
  must_init = TRUE,
  unresolved = c("warning", "error", "silent")
)

remove_job(job_id)
}
\arguments{
\item{fun}{function to evaluate}

\item{fun_args}{list of function arguments}

\item{packages}{list of packages to load}

\item{workdir}{working directory; default is temporary path}

\item{method}{job type; choices are \code{'rs_job'} (only used in
\code{'RStudio'} environment), \code{'mirai'} (when package \code{'mirai'}
is installed), and \code{'callr'} (default).}

\item{name}{name of the job}

\item{ensure_init}{whether to make sure the job has been started; default
is true}

\item{digest_key}{a string that will affect how job ID is generated;
used internally}

\item{envvars}{additional environment variables to set; must be a named
list of environment variables}

\item{job_id}{job identification number}

\item{timeout}{timeout in seconds before the resolve ends; jobs that
are still running are subject to \code{unresolved} policy}

\item{auto_remove}{whether to automatically remove the job if resolved;
default it true}

\item{must_init}{whether the resolve should error out if the job is not
initialized: typically meaning the either the resolving occurs too soon
(only when \code{ensure_init=FALSE}) or the job files are corrupted;
default is true}

\item{unresolved}{what to do if the job is still running after timing-out;
default is \code{'warning'} and return \code{NULL}, other choices are
\code{'error'} or \code{'silent'}}
}
\value{
For \code{start_job}, a string of job identification number;
\code{check_job} returns the job status; \code{resolve_job} returns
the function result.
}
\description{
Run a function (job) in another session
}
\examples{

\dontrun{

# Basic use
job_id <- start_job(function() {
  Sys.sleep(1)
  Sys.getpid()
})

check_job(job_id)

result <- resolve_job(job_id)


# As promise
library(promises)
as.promise(
  start_job(function() {
    Sys.sleep(1)
    Sys.getpid()
  })
) \%...>\%
  print()

}

}
