% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ravecore-package.R
\docType{package}
\name{ravecore-package}
\alias{ravecore}
\alias{ravecore-package}
\title{ravecore: Core File Structures and Workflows for 'RAVE'}
\description{
Defines storage standard for Read, process, and analyze intracranial electroencephalography and deep-brain stimulation in 'RAVE', a reproducible framework for analysis and visualization of iEEG by Magnotti, Wang, and Beauchamp, (2020, \doi{10.1016/j.neuroimage.2020.117341}). Supports brain imaging data structure (BIDS) \url{https://bids.neuroimaging.io} and native file structure to ingest signals from 'Matlab' data files, hierarchical data format 5 (HDF5), European data format (EDF), BrainVision core data format (BVCDF), or BlackRock Microsystem (NEV/NSx); process images in Neuroimaging informatics technology initiative (NIfTI) and 'FreeSurfer' formats, providing brain imaging normalization to template brain, facilitating 'threeBrain' package for comprehensive electrode localization via 'YAEL' (your advanced electrode localizer) by Wang, Magnotti, Zhang, and Beauchamp (2023, \doi{10.1523/ENEURO.0328-23.2023}).
}
\seealso{
Useful links:
\itemize{
  \item \url{https://rave.wiki}
  \item \url{http://rave.wiki/ravecore/}
  \item Report bugs at \url{https://github.com/rave-ieeg/ravecore/issues}
}

}
\author{
\strong{Maintainer}: Zhengjia Wang \email{dipterix.wang@gmail.com} (\href{https://orcid.org/0000-0001-5629-1116}{ORCID})

Authors:
\itemize{
  \item Xiang Zhang \email{xiang.zhang@pennmedicine.upenn.edu}
  \item John Magnotti \email{john.magnotti@pennmedicine.upenn.edu}
  \item Michael Beauchamp \email{michael.beauchamp@pennmedicine.upenn.edu}
}

Other contributors:
\itemize{
  \item Trustees of the University of Pennsylvania (All files in this package unless explicitly stated in the file) [copyright holder]
}

}
\keyword{internal}
