% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ENAdata.R
\docType{class}
\name{ENAdata}
\alias{ENAdata}
\title{ENAdata R6class}
\description{
ENAdata R6class

ENAdata R6class
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{raw}}{A data frame constructed from the unit, convo, code, and metadata parameters of ena.accumulate.data}

\item{\code{adjacency.vectors}}{A data frame of adjacency (co-occurrence) vectors by row}

\item{\code{accumulated.adjacency.vectors}}{A data frame of adjacency (co-occurrence) vectors accumulated per unit}

\item{\code{model}}{The type of ENA model: EndPoint, Accumulated Trajectory, or Separate Trajectory}

\item{\code{units}}{A data frame of columns that were combined to make the unique units. Includes column for trajectory selections. (unique)}

\item{\code{unit.names}}{A vector of unique unit values}

\item{\code{metadata}}{A data frame of unique metadata for each unit}

\item{\code{trajectories}}{A list: units - data frame, for a given row tells which trajectory it's a part; step - data frame, where along the trajectory a row sits}

\item{\code{adjacency.matrix}}{TBD}

\item{\code{adjacency.vectors.raw}}{TBD}

\item{\code{codes}}{A vector of code names}

\item{\code{function.call}}{The string representation of function called and parameters provided}

\item{\code{function.params}}{A list of all parameters sent to function call
Construct ENAdata}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ENAdata-new}{\code{ENAdata$new()}}
\item \href{#method-ENAdata-process}{\code{ENAdata$process()}}
\item \href{#method-ENAdata-get}{\code{ENAdata$get()}}
\item \href{#method-ENAdata-add.metadata}{\code{ENAdata$add.metadata()}}
\item \href{#method-ENAdata-clone}{\code{ENAdata$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ENAdata-new"></a>}}
\if{latex}{\out{\hypertarget{method-ENAdata-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ENAdata$new(
  file,
  units = NULL,
  units.used = NULL,
  units.by = NULL,
  conversations.by = NULL,
  codes = NULL,
  model = NULL,
  weight.by = "binary",
  window.size.back = 1,
  window.size.forward = 0,
  mask = NULL,
  include.meta = T,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file}}{TBD}

\item{\code{units}}{TBD}

\item{\code{units.used}}{TBD}

\item{\code{units.by}}{TBD}

\item{\code{conversations.by}}{TBD}

\item{\code{codes}}{TBD}

\item{\code{model}}{TBD}

\item{\code{weight.by}}{TBD}

\item{\code{window.size.back}}{TBD}

\item{\code{window.size.forward}}{TBD}

\item{\code{mask}}{TBD}

\item{\code{include.meta}}{TBD}

\item{\code{...}}{TBD}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Process accumulation
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ENAdata-process"></a>}}
\if{latex}{\out{\hypertarget{method-ENAdata-process}{}}}
\subsection{Method \code{process()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ENAdata$process()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
ENAdata
Get property from object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ENAdata-get"></a>}}
\if{latex}{\out{\hypertarget{method-ENAdata-get}{}}}
\subsection{Method \code{get()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ENAdata$get(x = "data")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{character key to retrieve from object}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
value from object at x
Add metadata
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ENAdata-add.metadata"></a>}}
\if{latex}{\out{\hypertarget{method-ENAdata-add.metadata}{}}}
\subsection{Method \code{add.metadata()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ENAdata$add.metadata(merge = F)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{merge}}{logical (default: FALSE)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
data.frame
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ENAdata-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ENAdata-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ENAdata$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
