% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diary_functions.R
\name{deff}
\alias{deff}
\title{Design Effect from Multilevel Numeric Vector}
\usage{
deff(x, grp, how = "lme", REML = TRUE)
}
\arguments{
\item{x}{numeric vector.}

\item{grp}{atomic vector the same length as \code{x} providing the grouping
variable.}

\item{how}{character vector of length 1 specifying how the ICC(1,1) should be
calculated. There are four options: 1) "lme" uses a linear mixed effects
model with the function \code{\link[nlme]{lme}} from the package
\code{nlme}, 2) "lmer" uses a linear mixed effects modeling with the
function \code{\link[lme4]{lmer}} from the package \code{lme4}, 3) "aov"
uses a one-way analysis of variance with the function
\code{\link[stats]{aov}}, and 4) "raw" uses the observed variances, which
provides a biased estimate of the ICC(1,1) and is not recommended (It is
only included for teaching purposes).}

\item{REML}{logical vector of length 1 specifying whether restricted maximum
likelihood estimation (TRUE) should be used rather than traditional maximum
likelihood estimation (FALSE). Only used for linear mixed effects models if
how = "lme" or how = "lmer".}
}
\value{
double vector of lenght 1 providing the design effect.
}
\description{
\code{deff} computes the design effect for a multilevel numeric vector.
Design effects summarize how much larger sampling variances (i.e., squared
standard errors) are due to the multilevel structure of the data. By taking
the square root, the value summarizes how much larger standard errors are due
to the multilevel structure of the data.
}
\details{
Design effects are a function of both the intraclass correlation (ICC) and
the average group size. Design effects can be large due to large ICCs and
small group sizes or small ICCs and large group sizes. For example, with an
ICC = .01 and average group size of 100, the design effect would be 2.0,
whose square root is 1.41. For more information, see myths 1 and 2 in
Huang (2018).
}
\examples{

icc_11(x = airquality$"Ozone", grp = airquality$"Month")
length_by(x = airquality$"Ozone", grp = airquality$"Month", na.rm = TRUE)
deff(x = airquality$"Ozone", grp = airquality$"Month")
sqrt(deff(x = airquality$"Ozone", grp = airquality$"Month")) # how much SE inflated

}
\references{
Huang, F. L. (2018). Multilevel modeling myths School Psychology Quarterly,
33(3), 492-499.
}
\seealso{
\code{\link{icc_11}}
   \code{\link{deffs}}
}
