% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pscData.R
\name{pscData}
\alias{pscData}
\title{A function which structures the Data Cohort in a format for model estimation}
\usage{
pscData(CFM, DC, id = NULL, trt = NULL)
}
\arguments{
\item{CFM}{a Counter Factual Model}

\item{DC}{a Data Cohort object}

\item{id}{to be specified for subgroup analysis. Defaults to NULL}

\item{trt}{to be specified for multiple treatment comparisons. Defaults to
NULL}
}
\value{
A set of structures for use with estimation procedures
}
\description{
This function ensures the data are supplied in a structure which allows for
estimation.  This is performed by re-fitting the original CFM with the DC and
extracting the appropriate structures.  Data are returned in terms of "Y" for
model outcomes, "X" for data and "Z" for random effects where mixed models
are supplied.
}
\examples{
e4_data <- psc::e4_data
gemCFM <- psc::gemCFM
pscOb <- pscData(gemCFM,e4_data)
}
