% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cal_rg_h2g_alltraits.R
\name{Cal_rg_h2g_alltraits}
\alias{Cal_rg_h2g_alltraits}
\title{Compute rg + h2g}
\usage{
Cal_rg_h2g_alltraits(
  phenotype,
  munged_sumstats,
  ld_path,
  wld_path,
  sample_prev = NULL,
  population_prev = NULL
)
}
\arguments{
\item{phenotype}{Vector of the phenotype name}

\item{munged_sumstats}{All LDSC-munged GWAS .stat.gz}

\item{ld_path}{Path to directory containing ld score files.}

\item{wld_path}{Path to directory containing weight files.}

\item{sample_prev}{Vector of sample prevalence, in the same order of input GWAS summary statistics.}

\item{population_prev}{Vector of population prevalence, in the same order of input GWAS summary statistics.}
}
\value{
A named list containing LDSC-based heritability and genetic correlation estimates
across all input phenotypes. The list includes the following elements:
\itemize{
  \item \code{h2}: Matrix of SNP-heritability estimates on the observed scale
        (rows = 1, columns = input phenotypes).
  \item \code{h2Z}: Matrix of corresponding heritability Z-scores.
  \item \code{liah2}: Matrix of heritability estimates on the liability scale.
  \item \code{rg}: Symmetric matrix of pairwise genetic correlations between traits.
  \item \code{rgz}: Matrix of Z-scores for the genetic correlation estimates.
  \item \code{gcov}: Symmetric matrix of genetic covariances between traits.
}

Each element corresponds to one LDSC-derived summary statistic, with trait names
used as both row and column names.
}
\description{
This function is used to compute rg + h2g using LDSC.
}
