% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/look_busy.R
\name{look_busy}
\alias{look_busy}
\title{Look like you're working hard when you're hardly working}
\usage{
look_busy(
  minutes = if (rlang::is_interactive()) Inf else 0,
  speed = 1,
  lambda = 3,
  background_job = FALSE,
  end = invisible(NULL)
)
}
\arguments{
\item{minutes}{How long to keep this up for.
Defaults to \code{Inf}, which runs forever.}

\item{speed}{How fast to produce output.
The default value, \code{1},
takes between 0.1 and 0.5 seconds to produce a calculation
and between 1 and 5 seconds to produce a status update.}

\item{lambda}{Input to a poisson distribution determining how many
calculations to perform between each message.
Defaults to \code{3}.}

\item{background_job}{Whether to produce output in in a background job
(if \code{TRUE}) or the console (if \code{FALSE}).
Defaults to \code{FALSE}.
Running in a background process requires the \link[job:job]{job} package.}

\item{end}{Code to run after \code{minutes}.
If \code{minutes} is \code{Inf}, \code{end} is never run.}
}
\value{
\code{end} if \code{minutes} is finite.
}
\description{
Look like you're working hard when you're hardly working
}
\examples{
look_busy()
}
\author{
Alexander Rossell Hayes \email{alexander@rossellhayes.com}
(\href{https://orcid.org/0000-0001-9412-0457}{ORCID})

With status messages contributed by:
\itemize{
\item Kristin Bott \email{kristin.bott@posit.co}
\item Daniel Chen \email{daniel.chen@posit.co}
(\href{https://orcid.org/0000-0003-3857-1741}{ORCID})
\item Steven Smallberg \email{steven.smallberg@posit.co}
}
}
