% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split.piar_index.R
\name{split.piar_index}
\alias{split.piar_index}
\alias{split<-.piar_index}
\title{Split an index into groups}
\usage{
\method{split}{piar_index}(x, f, drop = FALSE, ..., margin = c("levels", "time"))

\method{split}{piar_index}(x, f, drop = FALSE, ..., margin = c("levels", "time")) <- value
}
\arguments{
\item{x}{A price index, as made by, e.g., \code{\link[=elementary_index]{elementary_index()}}.}

\item{f}{A factor or list of factors to group elements of \code{x}.}

\item{drop}{Should levels that do not occur in \code{f} be dropped? By default
all levels are kept.}

\item{...}{Further arguments passed to \code{\link[=split.default]{split.default()}}.}

\item{margin}{Either 'levels' to split over the levels of \code{x} (the default),
or 'time' to split over the time periods of \code{x}.}

\item{value}{A list of values compatible with the splitting of \code{x}, or
something that can be coerced into one, recycled if necessary.}
}
\value{
\code{split()} returns a list of index objects for each level in \code{f}. The
replacement method replaces these values with the corresponding element of
\code{value}.
}
\description{
Split an index into groups of indexes according to a factor, along either
the levels or time periods of the index.
}
\examples{
index <- as_index(matrix(1:6, 2))

split(index, 1:2)

split(index, c(1, 1, 2), margin = "time")

}
\seealso{
Other index methods: 
\code{\link{[.piar_index}()},
\code{\link{aggregate.piar_index}},
\code{\link{as.data.frame.piar_index}()},
\code{\link{as.ts.piar_index}()},
\code{\link{chain}()},
\code{\link{contrib}()},
\code{\link{head.piar_index}()},
\code{\link{is.na.piar_index}()},
\code{\link{levels.piar_index}()},
\code{\link{mean.piar_index}},
\code{\link{merge.piar_index}()},
\code{\link{stack.piar_index}()},
\code{\link{time.piar_index}()},
\code{\link{window.piar_index}()}
}
\concept{index methods}
