% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.phylepic.R
\name{plot.phylepic}
\alias{plot.phylepic}
\alias{autoplot.phylepic}
\title{Plot "phylepic" objects}
\usage{
\method{plot}{phylepic}(
  x,
  ...,
  plot.tree = plot_tree(),
  plot.bars = plot_bars(),
  plot.calendar = plot_calendar(),
  plot.epicurve = plot_epicurve(),
  scale.date = NULL,
  scale.fill = NULL,
  width.tree = 10,
  width.bars = 1,
  width.date = 5,
  width.legend = 2,
  height.tree = 2
)

\method{autoplot}{phylepic}(
  object,
  ...,
  plot.tree = plot_tree(),
  plot.bars = plot_bars(),
  plot.calendar = plot_calendar(),
  plot.epicurve = plot_epicurve(),
  scale.date = NULL,
  scale.fill = NULL,
  width.tree = 10,
  width.bars = 1,
  width.date = 5,
  width.legend = 2,
  height.tree = 2
)
}
\arguments{
\item{...}{Ignored.}

\item{plot.tree}{ggplot for the tree panel (see \link{plot_tree}).}

\item{plot.bars}{ggplot for the metadata bars panel (see \link{plot_bars}).}

\item{plot.calendar}{ggplot for the calendar panel (see \link{plot_calendar}).}

\item{plot.epicurve}{ggplot for the epidemic curve panel (see \link{plot_epicurve}).}

\item{scale.date}{A date scale passed to both the calendar and epicurve panels
(see \link[ggplot2:scale_date]{ggplot2::scale_x_date}).}

\item{scale.fill}{A fill scale passed to both the calendar and epicurve panels
(see \link[ggplot2:scale_date]{ggplot2::scale_x_date}).}

\item{width.tree}{Relative width of the tree panel.}

\item{width.bars}{Relative width of the metadata bars panel.}

\item{width.date}{Relative width of the calendar panel.}

\item{width.legend}{Relative width of the legend, if present.}

\item{height.tree}{Relative height of the tree panel.}

\item{object, x}{Object of class "phylepic".}
}
\value{
\code{plot()} is usually called to display the plot, whereas \code{autoplot()}
returns a "ggplot" object that can later be displayed with \code{print()}.
}
\description{
The \code{autoplot()} and \code{plot()} methods for "phylepic" objects assemble various
panels into the final plot. To facilitate customisations, the plots from
each panel can be overwritten. Some effort is made to ensure that the
specified plots will look reasonable when assembled.
}
\details{
In general, if you wish to suppress a panel from the plot, set the
corresponding \verb{plot.*} argument to \code{NULL}. To customise it, use the
corresponding \verb{plot_*()} function, which returns a ggplot plot. You can then
add new layers or themes to that plot. See \code{vignette("phylepic")} for
examples.

Legends from all panels are collected and de-duplicated. They are drawn on
the right edge of the overall plot.
}
\seealso{
Other phylepic plots: 
\code{\link{plot_bars}()},
\code{\link{plot_calendar}()},
\code{\link{plot_epicurve}()},
\code{\link{plot_tree}()}
}
\concept{phylepic plots}
