% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/example.solar.irrad.data.r
\docType{data}
\name{four_days_1min.data}
\alias{four_days_1min.data}
\title{Ground level irradiance for wavelength bands}
\format{
A data frame with 24479 rows and 9 variables.
  variables.
}
\usage{
four_days_1min.data
}
\description{
Dataset containing mean values for observed terrestrial radiation for PAR,
UV-B, UV-A2, UV-A1, blue, red, and far-red photon irradiances and global
radiation energy irradiance. Values are summaries of 12 consecutive readings
acquired once every 5 s. The data set covers 4 consecutive days with
different cloud conditions.
}
\details{
The variables are as follows: 
\itemize{ 
\item time_EEST POSIXct Local time according to EET coordinates. 
\item UTC POSIXct Local time according to UTC. 
\item solar_time numeric Local solar time (h)
\item sun_elevation numeric Sun elevation above the astronomical horizon (degrees)
\item PAR_umo numeric (umol m-2 m-2) 
\item PAR_diff_fr numeric Fraction of total downwelling PAR that is diffuse (/1) 
\item global_watt numeric Global radiation (W m-2) 
\item red_umol numeric Red () light (umol m-2 m-2)
\item far_red_umol numeric Far red () light (umol m-2 m-2)
\item blue_umol numeric blue light () (umol m-2 m-2) 
\item blue_sellaro_umol numeric blue light () (umol m-2 m-2) 
\item UVA_umol numeric UV-A radiation (315-400 nm) (umol m-2 m-2) 
\item UVA1_umol numeric UV-A1 radiation (340-400 nm) (umol m-2 m-2) 
\item UVA2_umol numeric UV-A2 radiation (315-340 nm) (umol m-2 m-2) 
\item UVB_umol numeric UV-B radiation (280-315 nm) (umol m-2 m-2) 
\item solar_disk factor Estimate of whether the solar disk was visible or occluded (visible, occluded)
}

These data are part of a much larger data set (Aphalo, 2023).
  height. Data collected with a Campbell Scientific CR6 datalogger, using
  analogue outputs from the sensors. Location: Viikki campus of the
  University of Helsinki. Coordinates: 60.226803 N, 25.019205 E. Same data
  were plotted in Fig. 1 of Sellaro et al. (2024).
}
\examples{
colnames(four_days_1min.data)
nrow(four_days_1min.data)
range(four_days_1min.data$time_EET)
where_measured(four_days_1min.data)
how_measured(four_days_1min.data)
what_measured(four_days_1min.data)
comment(four_days_1min.data)

}
\references{
Aphalo, Pedro J. (2023) High frequency weather data for Viikki, Helsinki, 
Finland. \doi{10.17605/OSF.IO/E4VAU}.

Sellaro, Romina; Durand, Maaxime; Aphalo, Pedro J., Casal, Jorge J. (2024)
Making the most of canopy light: shade avoidance under a fluctuating spectrum
and irradiance. Journal of Experimental Botany, erae334. 
\doi{10.1093/jxb/erae334}.
}
\keyword{datasets}
