% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read-oojaz-file.r
\name{read_oo_jazirrad}
\alias{read_oo_jazirrad}
\alias{read_oo_jazpc}
\alias{read_oo_jazdata}
\title{Read Files Saved by Ocean Optics' Jaz spectrometer.}
\usage{
read_oo_jazirrad(
  file,
  date = NULL,
  geocode = NULL,
  label = NULL,
  tz = NULL,
  locale = readr::default_locale(),
  unit.in = "energy"
)

read_oo_jazpc(
  file,
  qty.in = "Tpc",
  Tfr.type = c("total", "internal"),
  Rfr.type = c("total", "specular"),
  date = NULL,
  geocode = NULL,
  label = NULL,
  tz = NULL,
  locale = readr::default_locale()
)

read_oo_jazdata(
  file,
  date = NULL,
  geocode = NULL,
  label = NULL,
  tz = NULL,
  locale = readr::default_locale()
)
}
\arguments{
\item{file}{character string Path to the file to be read, following R's
use of forward slashes as separator for folder names.}

\item{date}{a \code{POSIXct} object to use to set the \code{"when.measured"}
attribute. If \code{NULL}, the default, the date is extracted from the
file header.}

\item{geocode}{A data frame with columns \code{lon} and \code{lat}, and
optionally \code{address} used to set attribute \code{"where.measured"}.}

\item{label}{character string to which to set the \code{"what.measured"} 
attribute. If \code{NULL} the value of \code{basename(file)} is used, 
and if \code{NA} the \code{"what.measured"} attribute is not set.}

\item{tz}{character A time zone recognized by R. If \code{NULL}, the default,
it is extracted from `locale`.}

\item{locale}{The locale controls defaults that vary from place to place. 
 The default locale is US-centric (like R), but you can use
\code{\link[readr]{locale}} to create your own locale that controls things
like the default time zone, encoding, decimal mark, big mark, and day/month
names. Its value must match that used to write the imported file, which
is not necessarily the default one or the local one.}

\item{unit.in}{character One of "energy", "photon" (or "quantum"), for data
in uW cm-2 nm-1 and umol cm-2 nm-1.}

\item{qty.in}{character string, one of "Tpc" (spectral transmittance, \%), "A"
(spectral absorbance), or "Rpc" (spectral reflectance, \%).}

\item{Tfr.type}{character string, either "total" or "internal".}

\item{Rfr.type}{character string, either "total" or "specular".}
}
\value{
A source_spct object, a filter_spct object, a reflector_spct object
  or a raw_spct object.
}
\description{
Reads and parses the header of processed data text files output by
Jaz instruments extracting the spectral data from the body of the file 
and the metadata, including time and date of measurement from the header.
Jaz modular spectrometers were manufactured by Ocean Optics.
}
\details{
Function \code{read_oo_jazirrad} can read processed irradiance
output files. Function \code{read_oo_jazpc} can read processed transmittance
and reflectance output files (expressed as \%s). Function 
\code{read_oo_jazdata} can read raw-counts data.
}
\note{
Although the parameter is called \code{date} a date time is accepted 
  and expected. Time resolution is < 1 s if seconds are entered with a
  decimal fraction, such as "2021-10-05 10:10:10.1234".
}
\examples{

 file.name <- 
   system.file("extdata", "spectrum.jaz", 
               package = "photobiologyInOut", mustWork = TRUE)
                
 jaz.filter_spct <- read_oo_jazpc(file = file.name)
 
 jaz.filter_spct
 getWhenMeasured(jaz.filter_spct)
 getWhatMeasured(jaz.filter_spct)
 cat(comment(jaz.filter_spct))

 file.name <- 
   system.file("extdata", "spectrum.JazIrrad", 
               package = "photobiologyInOut", mustWork = TRUE)
                
 jaz.source_spct <- read_oo_jazirrad(file = file.name, unit.in = "energy")
 
 jaz.source_spct
 getWhenMeasured(jaz.source_spct)
 getWhatMeasured(jaz.source_spct)
 cat(comment(jaz.source_spct))
 q_irrad(jaz.source_spct, waveband(c(400, 700)), scale.factor = 1e6) # mol -> umol

}
\references{
\url{https://www.oceanoptics.com/}
}
