% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Goodman_diagonals_parameter_symmetry.R
\name{Goodman_constrained_diagonals_parameter_symmetry}
\alias{Goodman_constrained_diagonals_parameter_symmetry}
\title{Fits the model where some of the delta parameters are constrained to be equal to one another.}
\usage{
Goodman_constrained_diagonals_parameter_symmetry(n, equality)
}
\arguments{
\item{n}{the matrix of observed counts}

\item{equality}{logical vector indicating whether corresponding delta the parameter is part
of the equality set.}
}
\value{
a list containing
   pooled_chisq: Pearson chi-square for the pooled delta values
   pooled_df: degrees of freedom for pooled chisq
   omnibus_chisq: Pearson chi-square for overall model fit, subject to equality constraints
   omnibus_df; degrees of freedom for omnibus_chisq
   equality_chisq: Pearson chi-square for test that remaining deltas are all equal
   equality_df: degrees of freedom for equality_chisq
   delta_pooled: estimate of pooled delta
}
\description{
Fits the model where some of the delta parameters are constrained to be equal to one another.
}
\examples{
equality = c(TRUE, TRUE, FALSE)
Goodman_diagonals_parameter_symmetry(vision_data)
}
