% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_remove_tables}
\alias{wb_remove_tables}
\title{Remove a data table from a worksheet}
\usage{
wb_remove_tables(wb, sheet = current_sheet(), table, remove_data = TRUE)
}
\arguments{
\item{wb}{A Workbook object}

\item{sheet}{A name or index of a worksheet}

\item{table}{Name of table to remove. Use \code{\link[=wb_get_tables]{wb_get_tables()}} to view the
tables present in the worksheet.}

\item{remove_data}{Default \code{TRUE}. If \code{FALSE}, will only remove the data table attributes
but will keep the data in the worksheet.}
}
\value{
The \code{wbWorkbook}, invisibly
}
\description{
Remove tables in a workbook using its name.
}
\examples{
wb <- wb_workbook()
wb$add_worksheet(sheet = "Sheet 1")
wb$add_worksheet(sheet = "Sheet 2")
wb$add_data_table(sheet = "Sheet 1", x = iris, table_name = "iris")
wb$add_data_table(sheet = 1, x = mtcars, table_name = "mtcars", start_col = 10)

## delete worksheet removes table objects
wb <- wb_remove_worksheet(wb, sheet = 1)

wb$add_data_table(sheet = 1, x = iris, table_name = "iris")
wb$add_data_table(sheet = 1, x = mtcars, table_name = "mtcars", start_col = 10)

## wb_remove_tables() deletes table object and all data
wb_get_tables(wb, sheet = 1)
wb$remove_tables(sheet = 1, table = "iris")
wb$add_data_table(sheet = 1, x = iris, table_name = "iris")

wb_get_tables(wb, sheet = 1)
wb$remove_tables(sheet = 1, table = "iris")
}
