% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/notcore_utils.r
\name{print.vacalibration_summary}
\alias{print.vacalibration_summary}
\title{Print method for summarizing vacalibration results}
\usage{
\method{print}{vacalibration_summary}(x, top, rnd, algorithm, ...)
}
\arguments{
\item{x}{\code{vacalibration} object}

\item{top}{number of top CSMF to show}

\item{rnd}{number of decimal places to round the CSMF}

\item{algorithm}{a name or vector of names of algorithm(s) which
limits the output to those specific results}

\item{\dots}{not used}
}
\description{
This function prints a summary message of the results along with
the top cause-specific mortality fractions (CSMFs).
}
\examples{
\dontrun{
data(NeonatesVA5)
fit_insilico <- codeVA(NeonatesVA5)
insilico_prep <- prepCalibration(fit_insilico)
calib_insilico = vacalibration::vacalibration(va_data = insilico_prep,
                                              age_group = "neonate",
                                              country = "Mozambique")
summary(calib_insilico)

fit_interva <- codeVA(NeonatesVA5, model = "InterVA", version = "5", write = FALSE)
interva_prep <- prepCalibration(fit_interva)
calib_interva = vacalibration::vacalibration(va_data = interva_prep,
                                             age_group = "neonate",
                                             country = "Mozambique")
summary(calib_interva, top = 3, rnd = 2)

two_fits <- prepCalibration(fit_insilico, fit_interva)
calib_ensemble = vacalibration::vacalibration(va_data = two_fits,
                                              age_group = "neonate",
                                              country = "Mozambique")
summary(calib_ensemble, algorithm = "ensemble")
summary(calib_ensemble, algorithm = c("ensemble", "insilicova"))

}
}
