% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis.R
\name{plot_psbulk}
\alias{plot_psbulk}
\title{Plot a pseudobulk HMM profile}
\usage{
plot_psbulk(
  bulk,
  use_pos = TRUE,
  allele_only = FALSE,
  min_LLR = 5,
  min_depth = 8,
  exp_limit = 2,
  phi_mle = TRUE,
  theta_roll = FALSE,
  dot_size = 0.8,
  dot_alpha = 0.5,
  legend = TRUE,
  exclude_gap = TRUE,
  genome = "hg38",
  text_size = 10,
  raster = FALSE
)
}
\arguments{
\item{bulk}{dataframe Pseudobulk profile}

\item{use_pos}{logical Use marker position instead of index as x coordinate}

\item{allele_only}{logical Only plot alleles}

\item{min_LLR}{numeric LLR threshold for event filtering}

\item{min_depth}{numeric Minimum coverage depth for a SNP to be plotted}

\item{exp_limit}{numeric Expression logFC axis limit}

\item{phi_mle}{logical Whether to plot estimates of segmental expression fold change}

\item{theta_roll}{logical Whether to plot rolling estimates of allele imbalance}

\item{dot_size}{numeric Size of marker dots}

\item{dot_alpha}{numeric Transparency of the marker dots}

\item{legend}{logical Whether to show legend}

\item{exclude_gap}{logical Whether to mark gap regions and centromeres}

\item{genome}{character Genome build, either 'hg38' or 'hg19'}

\item{text_size}{numeric Size of text in the plot}

\item{raster}{logical Whether to raster images}
}
\value{
ggplot Plot of pseudobulk HMM profile
}
\description{
Plot a pseudobulk HMM profile
}
\examples{
p = plot_psbulk(bulk_example)
}
