% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GoalieEDGE.R
\name{goalie_edge_five_versus_five}
\alias{goalie_edge_five_versus_five}
\alias{goalie_edge_5_vs_5}
\title{Access the EDGE 5 vs. 5 statistics for a goalie, season, game type, and
category}
\usage{
goalie_edge_five_versus_five(
  player = 8476945,
  season = "now",
  game_type = "",
  category = "details"
)

goalie_edge_5_vs_5(
  player = 8476945,
  season = "now",
  game_type = "",
  category = "details"
)
}
\arguments{
\item{player}{integer ID (e.g., 8478406)}

\item{season}{integer in YYYYYYYY (e.g., 20242025); see
\code{\link[=goalie_edge_seasons]{goalie_edge_seasons()}} for reference}

\item{game_type}{integer in 1:3 (where 1 = pre-season, 2 = regular season, 3
= playoff/post-season) OR character of 'pre', 'regular', or
'playoff'/'post'; see \code{\link[=goalie_edge_seasons]{goalie_edge_seasons()}} for reference; most functions
will NOT support pre-season}

\item{category}{character of 'd'/'details' or 'l'/'l10'/'last 10'}
}
\value{
list with four items (category = 'details') or data.frame with
one row per game (category = 'last 10')
}
\description{
\code{goalie_edge_five_versus_five()} scrapes the EDGE 5 vs. 5 statistics for a given set
of \code{goalie}, \code{season}, \code{game_type}, and \code{category}.
}
\examples{
Mackenzie_Blackwood_L10_5_vs_5_regular_20242025 <- goalie_edge_five_versus_five(
  player    = 8478406,
  season    = 20242025,
  game_type = 2,
  category  = 'L'
 )
}
