% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Clean.R
\name{calculate_distance}
\alias{calculate_distance}
\title{Calculate the Euclidean distance from the attacking net for all the events
(plays) in a play-by-play}
\usage{
calculate_distance(play_by_play)
}
\arguments{
\item{play_by_play}{data.frame of play-by-play(s); see \code{\link[=gc_play_by_play]{gc_play_by_play()}}
and/or \code{\link[=wsc_play_by_play]{wsc_play_by_play()}} for reference; must be untouched by
non-nhlscraper functions; saves time if \code{\link[=normalize_coordinates]{normalize_coordinates()}} has
already been called}
}
\value{
data.frame with one row per event (play) and added \code{distance} column
}
\description{
\code{calculate_distance()} calculates the Euclidean distance from the attacking
net for all the events (plays) in a play-by-play.
}
\examples{
# May take >5s, so skip.
\donttest{
  test                     <- gc_play_by_play()
  test_is_home_flagged     <- flag_is_home(test)
  test_coords_normalized   <- normalize_coordinates(test_is_home_flagged)
  test_distance_calculated <- calculate_distance(test_coords_normalized)
}
}
