% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flip_img.R
\name{flip_img}
\alias{flip_img}
\title{Flip NIfTI Image}
\usage{
flip_img(img, x = FALSE, y = FALSE, z = FALSE, ...)
}
\arguments{
\item{img}{nifti object or character filename}

\item{x}{(logical) Flip x direction}

\item{y}{(logical) Flip y direction}

\item{z}{(logical) Flip z direction}

\item{...}{Arguments passed to \code{\link{check_nifti}}}
}
\value{
Object of class nifti
}
\description{
This image will flip x, y, or z direction
}
\examples{
img = random_nifti(rep(15, 3))
flipped = flip_img(img, x = TRUE, y = TRUE, z = TRUE)
img = random_nifti(rep(15, 2))
flipped = flip_img(img, x = TRUE)
testthat::expect_error(flip_img(img, z= TRUE))
}
