# WARNING - Generated by {fusen} from dev/flat_teaching.Rmd: do not edit by hand

# Test import_xlsx functionality
test_that("import_xlsx reads Excel files correctly", {
  # Setup test files
  xlsx_files <- mintyr_example(
    mintyr_examples(pattern = "xlsx_test")  # Get example Excel files
  )
  
  # Test basic functionality with rbind = TRUE
  test_that("import_xlsx combines all sheets with rbind = TRUE", {
    result <- import_xlsx(xlsx_files, rbind = TRUE)
    
    # Check return type
    expect_s3_class(result, "data.table")
    
    # Check required columns exist
    expect_true(all(c("excel_name", "sheet_name") %in% names(result)))
    
    # Check data is not empty
    expect_true(nrow(result) > 0)
  })
  
  # Test with rbind = FALSE
  test_that("import_xlsx returns list of sheets with rbind = FALSE", {
    result <- import_xlsx(xlsx_files, rbind = FALSE)
    
    # Check return type
    expect_type(result, "list")
    
    # Check each element is a data.table
    expect_true(all(sapply(result, data.table::is.data.table)))
  })
  
  # Test sheet selection
  test_that("import_xlsx handles sheet parameter correctly", {
    # Test specific sheet selection
    result_sheet1 <- import_xlsx(xlsx_files, sheet = 1)
    expect_true(all(result_sheet1$sheet_name == "Sheet1"))
    
    # Test multiple sheet selection
    result_sheets <- import_xlsx(xlsx_files, sheet = c(1, 2))
    expect_true(all(result_sheets$sheet_name %in% c("Sheet1", "Sheet2", "a")))
  })
})

# Test error handling
test_that("import_xlsx handles errors appropriately", {
  # Setup test files
  xlsx_files <- mintyr_example(
    mintyr_examples(pattern = "\\.xlsx$")
  )
  
  # Test invalid file path
  expect_error(
    import_xlsx("nonexistent.xlsx"),
    "file must be a vector of existing file paths"
  )
  
  # Test invalid rbind parameter
  expect_error(
    import_xlsx(xlsx_files, rbind = "TRUE"),
    "Parameter 'rbind' should be logical"
  )
  
  # Test invalid sheet parameter
  expect_error(
    import_xlsx(xlsx_files, sheet = "1"),
    "sheet parameter must be a numeric vector or NULL"
  )
  
  # Test out of range sheet index
  expect_error(
    import_xlsx(xlsx_files, sheet = 999),
    "sheet parameter contains indices out of range"
  )
})

# Test edge cases
test_that("import_xlsx handles edge cases", {
  # Setup test files
  xlsx_files <- mintyr_example(
    mintyr_examples(pattern = "\\.xlsx$")
  )
  
  # Test single file
  single_result <- import_xlsx(xlsx_files[1])
  expect_s3_class(single_result, "data.table")
  
  # Test multiple files
  multi_result <- import_xlsx(xlsx_files)
  expect_s3_class(multi_result, "data.table")
  
  # Test with empty sheets (if applicable)
  # Note: This test depends on your test file structure
  
  # Test with different column names across sheets
  # Note: This test depends on your test file structure
})
