% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hypvolgmm.R
\name{hypvolgmm}
\alias{hypvolgmm}
\title{Gaussian mixture-based hypervolume estimation of multivariate data}
\usage{
hypvolgmm(
  data,
  method = c("lhs", "smc", "is", "none"),
  G = 1:9,
  prior = TRUE,
  nsim = 1e+06,
  hdlevel = NULL,
  GMM = NULL,
  ...
)
}
\arguments{
\item{data}{A numeric vector, matrix, or data frame. If a matrix or
data frame, rows correspond to observations and columns correspond
to variables. Categorical variables and missing values are not allowed.}

\item{method}{A character specifying the sampling scheme to be used for
the estimation. Available options are:
\itemize{
\item \code{"lhs"} = Latin Hypercube Sampling (default);
\item \code{"smc"} = Simple Monte Carlo sampling;
\item \code{"is"} = Importance Sampling.
}}

\item{G}{An integer vector specifying the numbers of mixture components to fit,
then model selection if performed via BIC.}

\item{prior}{A logical specifying if a prior (on the covariance) matrix should
be used for regularization.}

\item{nsim}{Integer specifying the number of simulations used in MC sampling.}

\item{hdlevel}{A numerical value in the range (0,1] specifying the level
of the highest density region (HDR) to be used for defining the GMM hull.
If not provided, a default data-driven value is computed.}

\item{GMM}{Optional \code{Mclust} or \code{densityMclust} object to be used.
If provided, the \code{data} argument is ignored.}

\item{\dots}{Further arguments passed to or from other methods.}
}
\value{
Returns a list containing the following elements:
\itemize{
\item \code{GMM} An object of class \code{densityMclust} containing the fitted
Gaussian mixture.
\item \code{method} The sampling method employed.
\item \code{hdlevel} The hdlevel used for definying the GMM hull.
\item \code{nsim}	The number of simulations used in MC sampling.
\item \code{ESS}	The effective sample size.
\item \code{h}	The density level of GMM hull.
\item \code{gamma}	The estimated parameter used for adjustment
\item \code{logvol} The estimated log hypervolume.
}
}
\description{
Estimates the hypervolume of a multivariate dataset by fitting a
Gaussian Mixture Model (GMM).
}
\examples{
x = matrix(rnorm(100), ncol = 2)
mod = hypvolgmm(x)
summary(mod$GMM)
mod$logvol

}
\author{
Luca Scrucca
}
