% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kuzu.R
\name{kuzu_connection}
\alias{kuzu_connection}
\title{Create a Connection to a Kuzu Database}
\usage{
kuzu_connection(path)
}
\arguments{
\item{path}{A string specifying the file path for the database. For an
in-memory database, use \code{":memory:"}.}
}
\value{
A Python object representing the connection to the Kuzu database.
}
\description{
Establishes a connection to a Kuzu database. If the database does not exist
at the specified path, it will be created. This function combines the
database initialization and connection steps into a single call.
}
\examples{
\donttest{
# Create an in-memory database and connection
conn <- kuzu_connection(":memory:")

# Create or connect to an on-disk database
temp_db_dir <- file.path(tempdir(), "kuzu_disk_example_db")
db_path <- file.path(temp_db_dir, "kuzu_db")
dir.create(temp_db_dir, recursive = TRUE, showWarnings = FALSE)

# Establish connection
conn_disk <- kuzu_connection(db_path)

# Ensure the database is shut down and removed on exit
on.exit({
  # Access the 'db' object from the reticulate main module
  main <- reticulate::import_main()
  if (!is.null(main$db)) {
    main$db$shutdown()
  }
  unlink(temp_db_dir, recursive = TRUE)
})
}
}
