% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_raw.R
\name{orbi_check_isoraw}
\alias{orbi_check_isoraw}
\title{Check for the isoorbi raw file reader}
\usage{
orbi_check_isoraw(
  install_if_missing = !on_cran(),
  reinstall_if_outdated = !on_cran(),
  reinstall_always = FALSE,
  min_version = "0.2.2",
  source = paste0("https://github.com/isoverse/isoorbi/releases/download/isoraw-v",
    min_version),
  accept_license = FALSE,
  ...
)
}
\arguments{
\item{install_if_missing}{install the reader if it's missing}

\item{reinstall_if_outdated}{install the reader if it's outdated (i.e. not at least \code{min_version})}

\item{reinstall_always}{whether to (re-)install no matter what}

\item{min_version}{the minimum version number required}

\item{source}{the URL (or local path) where to find the raw file reader, by default this is the latests release of the executables on github}

\item{accept_license}{explicitly accept Thermo's license agreement (if this is FALSE and the license has not previously been accepted, you will be asked about it)}

\item{...}{passed on to \code{download.file} if (re-) installing the reader}
}
\description{
By default, this will install the isoraw reader if it is missing or outdated, and will ask the user to agree to Thermo's license agreement
for the \href{https://github.com/thermofisherlsms/RawFileReader}{Thermo RawFileReader} before proceeding.
This function runs automatically during a raw file read and does not usually need to be called directly by the user.
}
