% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/incRplot.R
\name{incRplot}
\alias{incRplot}
\title{Quick visualisation of incubation temperatures, on-bouts and off-bouts}
\usage{
incRplot(
  data,
  time.var,
  day.var,
  inc.temperature.var,
  env.temperature.var = NULL,
  vector.incubation
)
}
\arguments{
\item{data}{data table with incubation temperature data}

\item{time.var}{Character string. Name of the variable with time of the day for
temperature data. Please, have time in 
decimal hours. If \code{\link{incRprep}} has been previously used, "dec_time" can
be used.}

\item{day.var}{Character string. Name of the variable with date for
temperature observation. No specific format is needed. 
If \code{\link{incRprep}} has been previously used, "date" can
be used.}

\item{inc.temperature.var}{Character string. Name of the variable with incubation 
temperatures.}

\item{env.temperature.var}{Character string. Name of the variable with environmental
temperatures. If no value is provided, a plot with no environmental temperatures
is produced.}

\item{vector.incubation}{name of the binary variable storing
information about the presence/absence of the incubating individual in the nest.
If \code{\link{incRscan}} has been used, "incR_score" can be used.}
}
\value{
Plot of incubation temperature, on-bouts and off-bouts with (optional) 
environmental temperatures. The plot is generated using \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}.The
user can customised the appearance of the plot using tools 
within \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}(see example)
}
\description{
After \code{\link{incRscan}} has been used, \code{\link{incRplot}}
provides a quick visualisation of the incubation temperature trace with coloured
on- and off-bouts. Environmental temperatures can also be added to the plot
}
\examples{
# loading example data
data(incR_procdata)
my_plot <- incRplot(data = incR_procdata[complete.cases(incR_procdata$temperature),], 
                    time.var = "dec_time", 
                    day.var = "date", 
                    inc.temperature.var = "temperature", 
                    env.temperature.var = "env_temp",
                    vector.incubation = "incR_score")
                    
# see your plot
my_plot

# add new labels (ggplot2 required)
my_plot + ggplot2::labs(x = "New X label", y = "New Y label")
}
\seealso{
\code{\link{incRscan}}
}
