% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imf_get_codelists.R
\name{imf_get_codelists}
\alias{imf_get_codelists}
\title{Retrieve codes for one or more dimensions as a tidy tibble}
\usage{
imf_get_codelists(
  dimension_ids,
  dataflow_id,
  progress = FALSE,
  max_tries = 10L,
  cache = TRUE
)
}
\arguments{
\item{dimension_ids}{Character vector of dimension IDs (e.g., "COUNTRY").}

\item{dataflow_id}{Character scalar. The dataflow whose datastructure is
used to resolve each dimension's codelist via its concept scheme reference.}

\item{progress}{Logical; whether to show progress.}

\item{max_tries}{Integer; maximum retry attempts.}

\item{cache}{Logical; whether to cache requests.}
}
\value{
tibble::tibble(
dimension_id = character(),
code = character(),
name = character(),
description = character(),
codelist_id = character(),
codelist_agency = character(),
codelist_version = character()
)
}
\description{
Returns a tibble mapping dimensions to their codes and labels by fetching the
corresponding codelists. By convention, codelist IDs are assumed to be
\verb{CL_\{dimension_id\}} for first-pass coverage.
}
\examples{
\donttest{
if (curl::has_internet()) {
  imf_get_codelists(
    c("FREQUENCY", "TIME_PERIOD"),
    dataflow_id = "FM"  # Fiscal Monitor
  )
}
}
}
