% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans.colors.R
\name{trans.colors}
\alias{trans.colors}
\title{Make Colors Transparent}
\usage{
trans.colors(col, alpha = 0.5, names = NULL)
}
\arguments{
\item{col}{A character vector of colors, either as color names or rgb hex
values}

\item{alpha}{alpha transparency value(s) to apply to each color (0 means
fully transparent and 1 means opaque)}

\item{names}{optional character vector of names for the colors}
}
\value{
A vector of color values of the form \code{"#rrggbbaa"}
}
\description{
Takes a vector of colors (as color names or rgb hex values) and adds a
specified alpha transparency to each.
}
\details{
Colors (\code{col}) and \code{alpha} need not be of the same length. The
shorter one is replicated to make them of the same length.
}
\examples{

trans.colors(palette(), alpha=0.5)

# alpha can be vectorized
trans.colors(palette(), alpha=seq(0, 1, length=length(palette())))

# lengths need not match: shorter one is repeated as necessary
trans.colors(palette(), alpha=c(.1, .2))

trans.colors(colors()[1:20])

# single color, with various alphas
trans.colors("red", alpha=seq(0,1, length=5))
# assign names
trans.colors("red", alpha=seq(0,1, length=5), names=paste("red", 1:5, sep=""))


}
\seealso{
\%\% ~~objects to See Also as \code{\link{help}}, ~~~
\code{\link[grDevices]{col2rgb}}, \code{\link[grDevices]{rgb}},
\code{\link[grDevices]{adjustcolor}},
}
\author{
Michael Friendly
}
\keyword{color}
