% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covEllipses.R
\name{covEllipses}
\alias{covEllipses}
\alias{covEllipses.boxM}
\alias{covEllipses.data.frame}
\alias{covEllipses.matrix}
\alias{covEllipses.default}
\alias{covEllipses.formula}
\title{Draw classical and Robust Covariance Ellipses for one or more groups}
\usage{
covEllipses(x, ...)

\method{covEllipses}{data.frame}(
  x,
  group,
  pooled = TRUE,
  method = c("classical", "mve", "mcd"),
  ...
)

\method{covEllipses}{matrix}(
  x,
  group,
  pooled = TRUE,
  method = c("classical", "mve", "mcd"),
  ...
)

\method{covEllipses}{formula}(x, data, ...)

\method{covEllipses}{boxM}(x, ...)

\method{covEllipses}{default}(
  x,
  means,
  df,
  labels = NULL,
  variables = 1:2,
  level = 0.68,
  segments = 60,
  center = FALSE,
  center.pch = "+",
  center.cex = 2,
  col = getOption("heplot.colors", c("red", "blue", "black", "darkgreen", "darkcyan",
    "brown", "magenta", "darkgray")),
  lty = 1,
  lwd = 2,
  fill = FALSE,
  fill.alpha = 0.3,
  label.pos = 0,
  xlab,
  ylab,
  vlabels,
  var.cex = 2,
  main = "",
  xlim,
  ylim,
  axes = TRUE,
  offset.axes,
  add = FALSE,
  ...
)
}
\arguments{
\item{x}{The generic argument. For the default method, this is a list of
covariance matrices. For the \code{data.frame} and \code{matrix} methods,
this is a numeric matrix of two or more columns supplying the variables to
be analyzed.}

\item{\dots}{Other arguments passed to the default method for \code{plot},
\code{text}, and \code{points}}

\item{group}{a factor defining groups, or a vector of length
\code{n=nrow(x)} doing the same. If missing, a single covariance ellipse is
drawn.}

\item{pooled}{Logical; if \code{TRUE}, the pooled covariance matrix for the
total sample is also computed and plotted}

\item{method}{the covariance method to be used: classical product-moment
(\code{"classical"}), or minimum volume ellipsoid (\code{"mve"}), or minimum
covariance determinant (\code{"mcd"}).}

\item{data}{For the \code{formula} method, a data.frame in which to evaluate.}

\item{means}{For the default method, a matrix of the means for all groups
(followed by the grand means, if \code{pooled=TRUE}). Rows are the groups,
and columns are the variables. It is assumed that the means have column
names corresponding to the variables in the covariance matrices.}

\item{df}{For the default method, a vector of the degrees of freedom for the
covariance matrices}

\item{labels}{Either a character vector of labels for the groups, or
\code{TRUE}, indicating that group labels are taken as the names of the
covariance matrices. Use \code{labels=""} to suppress group labels, e.g.,
when \code{add=TRUE}}

\item{variables}{indices or names of the response variables to be plotted;
defaults to \code{1:2}.  If more than two variables are supplied, the
function plots all pairwise covariance ellipses in a scatterplot matrix
format.}

\item{level}{equivalent coverage of a data ellipse for normally-distributed
errors, defaults to \code{0.68}.}

\item{segments}{number of line segments composing each ellipse; defaults to
\code{40}.}

\item{center}{If \code{TRUE}, the covariance ellipses are centered at the
centroid.}

\item{center.pch}{character to use in plotting the centroid of the data;
defaults to \code{"+"}.}

\item{center.cex}{size of character to use in plotting the centroid (means) of the
data; defaults to \code{2}.}

\item{col}{a color or vector of colors to use in plotting ellipses---
recycled as necessary--- see Details. A single color can be given, in which case it is used
for all ellipses.  For convenience, the default colors for all plots
produced in a given session can be changed by assigning a color vector via
\verb{options(heplot.colors =c(...)}.  Otherwise, the default colors are
\code{c("red", "blue", "black", "darkgreen", "darkcyan", "magenta", "brown", "darkgray")}.}

\item{lty}{vector of line types to use for plotting the ellipses---
recycled as necessary--- see Details.  Defaults to \code{1}.}

\item{lwd}{vector of line widths to use for plotting the ellipses---
recycled as necessary--- see Details.  Defaults to
\code{2}.}

\item{fill}{A logical vector indicating whether each ellipse should be
filled or not--- recycled as necessary--- see Details.   Defaults to \code{FALSE}.}

\item{fill.alpha}{Alpha transparency for filled ellipses, a numeric scalar
or vector of values within \verb{[0,1]}, where 0 means fully transparent and
1 means fully opaque. Defaults to 0.3.}

\item{label.pos}{Label position, a vector of integers (in \code{0:4}) or
character strings (in \code{c("center", "bottom", "left", "top", "right")})
use in labeling ellipses, recycled as necessary.  Values of 1, 2, 3 and 4,
respectively indicate positions below, to the left of, above and to the
right of the max/min coordinates of the ellipse; the value 0 specifies the
centroid of the \code{ellipse} object.  The default, \code{label.pos=NULL}
uses the correlation of the \code{ellipse} to determine "top" (r>=0) or
"bottom" (r<0).}

\item{xlab}{x-axis label; defaults to name of the x variable.}

\item{ylab}{y-axis label; defaults to name of the y variable.}

\item{vlabels}{Labels for the variables can also be supplied through this
argument, which is more convenient when \code{length(variables) > 2}.}

\item{var.cex}{character size for variable labels in the pairs plot, when \code{length(variables) > 2}.}

\item{main}{main plot label; defaults to \code{""}, and presently has no
effect.}

\item{xlim}{x-axis limits; if absent, will be computed from the data.}

\item{ylim}{y-axis limits; if absent, will be computed from the data.}

\item{axes}{Whether to draw the x, y axes; defaults to \code{TRUE}}

\item{offset.axes}{proportion to extend the axes in each direction if
computed from the data; optional.}

\item{add}{if \code{TRUE}, add to the current plot; the default is
\code{FALSE}. This argument is has no effect when more than two variables
are plotted.}
}
\value{
Nothing is returned.  The function is used for its side-effect of
producing a plot. \%Returns invisibly an object of class \code{"covEllipse"},
\%which is a list of the coordinates for the ellipses drawn.
}
\description{
The function draws covariance ellipses for one or more groups and optionally
for the pooled total sample.  It uses either the classical product-moment
covariance estimate, or a robust alternative, as provided by
\code{\link[MASS]{cov.rob}}. Provisions are provided to do this for more
than two variables, in a scatterplot matrix format.

These plot methods provide one way to visualize possible heterogeneity of
within-group covariance matrices in a one-way MANOVA design. When covariance
matrices are nearly equal, their covariance ellipses should all have the
same shape.  When centered at a common mean, they should also all overlap.

They can also be used to visualize the difference between classical and
robust covariance matrices by overlaying the two in a single plot (via \code{add=TRUE}).
}
\details{
The arguments \code{labels},
\code{col}, \code{lty}, \code{lwd}, \code{fill}, \code{fill.alpha} and \code{label.pos} are used to
draw the ellipses for the groups and also for the pooled, within-group covariance, which is the \strong{last} in a list
when these are computed by the functions.
These arguments are each taken in the order specified, and recycled as necessary.
}
\examples{


data(iris)

# compare classical and robust covariance estimates
covEllipses(iris[,1:4], iris$Species)
# use `method="mve"`
covEllipses(iris[,1:4], iris$Species, 
    fill=TRUE, method="mve", add=TRUE, labels="")

# method for a boxM object	
iris.boxM <- boxM(iris[, 1:4], iris[, "Species"])
iris.boxM
# show the associated covariance ellipses
covEllipses(iris.boxM, fill=c(rep(FALSE,3), TRUE) )
# use centering
covEllipses(iris.boxM, fill=c(rep(FALSE,3), TRUE), center=TRUE, label.pos=1:4 )

# method for a list of covariance matrices
cov <- c(iris.boxM$cov, pooled=list(iris.boxM$pooled))
df <- c(table(iris$Species)-1, nrow(iris)-3)
covEllipses(cov, iris.boxM$means, df, label.pos=3, fill=c(rep(FALSE,3), TRUE))
 
covEllipses(cov, iris.boxM$means, df, label.pos=3, fill=c(rep(FALSE,3), TRUE), center=TRUE)

# scatterplot matrix version, specifying `variables`
covEllipses(iris[,1:4], iris$Species, 
	fill=c(rep(FALSE,3), TRUE), variables=1:4, 
	fill.alpha=.1)


}
\seealso{
\code{\link{heplot}}, \code{\link{boxM}},

\code{\link[MASS]{cov.rob}}

Other covariance ellipses: 
\code{\link{ellipse.axes}()},
\code{\link{ellipse.box}()},
\code{\link{ellipse3d.axes}()}
}
\author{
Michael Friendly
}
\concept{covariance ellipses}
\keyword{hplot}
\keyword{multivariate}
