% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group.R
\name{group}
\alias{group}
\title{Group level confidence intervals and between-group variation}
\usage{
group(
  x,
  y,
  z = NULL,
  dataf,
  dist = "t",
  conf.int = 0.95,
  increment = 1,
  rolling = NULL,
  quarts = FALSE,
  cluster = FALSE
)
}
\arguments{
\item{x}{group predictor variable name.}

\item{y}{outcome variable name.}

\item{z}{time period variable name.}

\item{dataf}{name of data frame object.}

\item{dist}{indicate the distribution used for confidence intervals. Options
for the t, binomial, and exact Poisson distributions. Options are 't', 'b', and 'p'.
Default is the 't'.}

\item{conf.int}{select the confidence interval level. Default is 0.95.}

\item{increment}{specify the increment in time periods. Selecting 3 if data uses
the month as the unit of time will give confidence intervals, each based on 3 months.
Default is 1.}

\item{rolling}{indicate the number of time periods for the 'rolling average'.
The rolling average consists of >1 time periods but subsequent point estimate
increase by a unit of 1. For example, the common 12-month rolling average is
based on months 1-12 of data, followed by the next estimate using months 2-13,
3-14, and so on until the last month in the data has been reached. Default is NULL.}

\item{quarts}{logical TRUE or FALSE that indicates whether to convert continuous x
into 4 groups based on quartiles of x. Default is FALSE.}

\item{cluster}{logical TRUE or FALSE to generate measures of between-group variation
such as the Intra-Class Correlation, Median Odds Ratio, or Design Effect. Default is FALSE.
Uses binary outcome formula (between-group variance/(between-group variance + (3.14^2/3)) for ICC
in Rabe-Hesketh which may be more appropriate for multilevel models. ICC, MOR, DE may be less
reliable for binomial and Poisson distributions, use caution.}
}
\value{
list of confidence intervals for outcomes by groups, over time,
and clustering measures. Some values returned in alphabetical and numerical order based on the group.
}
\description{
Group level confidence intervals and between-group variation
}
\examples{
#default t distribution results
group(x="program", y="los", dataf=hosprog)
#Rounding LOS to integers
hp2 <- hosprog; hp2$los2 <- round(hp2$los, 0)
#Exact Poisson confidence intervals
group(x="program", y="los2", dataf=hp2, dist="p")
#Rolling 6-months of data
group(x="program", y="los", z="month", dataf=hosprog, dist="t", rolling=6)
#Data returned separately for rolling 6-months of data and 3-month increments (e.g., quarters)
group(x="program", y="los", z="month", dataf=hosprog, dist="t", increment=3, rolling=6)
#Quartile groups for continuous risk score and returned clustering info
group(x="risk", y="los", dataf=hosprog, quarts=TRUE, cluster=TRUE)
#Binomial distribution with less conservative 90\% confidence intervals
group(x="risk", y="rdm30", dataf=hosprog, quarts=TRUE, dist="b", conf.int=0.90)
}
\references{
Merlo, J. (2006). A brief conceptual tutorial of multilevel analysis in
social epidemiology: using measures of clustering in multilevel logistic
regression to investigate contextual phenomena. Journal of Epidemiological Health, 60, 4,
290-297. https://doi.org/10.1136/jech.2004.029454.

Muthen, B. & Satorra, A. (1995). Complex Sample Data in Structural Equation Modeling.
Sociological Methodology, 25, 267-316. https://doi.org/10.2307/271070.

Rabe-Hesketh, S. & Skrondal, A. (2008). Multilevel and Longitudinal Modeling Using Stata,
Second Edition. ISBN: 978-1-59718-040-5.
}
