% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stnd_cor.R
\name{stnd_cor}
\alias{stnd_cor}
\title{Standard Guessing Correction for Learning}
\usage{
stnd_cor(pre_test = NULL, pst_test = NULL, lucky = NULL, item_names = NULL)
}
\arguments{
\item{pre_test}{Required. data.frame carrying responses to pre-test questions.}

\item{pst_test}{Required. data.frame carrying responses to post-test questions.}

\item{lucky}{Required. A vector. Each entry is 1/(number of options)}

\item{item_names}{Optional. A vector carrying item names.}
}
\value{
a list of three vectors, carrying pre-treatment corrected scores, post-treatment scores, and adjusted estimates of learning
}
\description{
Estimate of learning adjusted with standard correction for guessing. Correction is based on number of options per question.
The function takes separate pre-test and post-test dataframes. Why do we need dataframes? To accomodate multiple items.
The items can carry NA (missing). Items must be in the same order in each dataframe. Assumes that respondents are posed same questions twice. 
The function also takes a \code{lucky} vector --- the chance of getting a correct answer if guessing randomly. Each entry is 1/(number of options).
The function also optionally takes a vector carrying names of the items. By default, the vector carrying adjusted learning estimates takes same 
item names as the pre_test items. However you can assign a vector of names separately via \code{item_names}.
}
\examples{
# Without DK
pre_test <- data.frame(item1 = c(1,0,0,1,0), item2 = c(1,NA,0,1,0)) 
pst_test <- pre_test + cbind(c(0,1,1,0,0), c(0,1,0,0,1))
lucky <- rep(.25, 2); stnd_cor(pre_test, pst_test, lucky)
# With DK
pre_test <- data.frame(item1 = c(1,0,0,1,0,'d',0), item2 = c(1,NA,0,1,0,'d','d')) 
pst_test <- data.frame(item1 = c(1,0,0,1,0,'d',1), item2 = c(1,NA,0,1,0,1,'d')) 
lucky <- rep(.25, 2); stnd_cor(pre_test, pst_test, lucky)
}
